/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.processors.query.h2.opt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.Accountable;
import org.gridgain.internal.processors.query.h2.opt.GridLuceneDirectory;

public class GridLuceneFile
implements Accountable {
    private LongArray buffers = new LongArray();
    private long length;
    private final String name;
    private final GridLuceneDirectory dir;
    private volatile long sizeInBytes;
    private final AtomicLong refCnt = new AtomicLong();
    private final AtomicBoolean deleted = new AtomicBoolean();

    GridLuceneFile(GridLuceneDirectory dir, String name) {
        this.dir = dir;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long length) {
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long addBuffer() {
        long buf = this.newBuffer();
        GridLuceneFile gridLuceneFile = this;
        synchronized (gridLuceneFile) {
            this.buffers.add(buf);
            this.sizeInBytes += 32768L;
        }
        if (this.dir != null) {
            this.dir.sizeInBytes.getAndAdd(32768L);
        }
        return buf;
    }

    void lockRef() {
        this.refCnt.incrementAndGet();
    }

    void releaseRef() {
        this.refCnt.decrementAndGet();
        this.deferredDelete();
    }

    boolean hasRefs() {
        long refs = this.refCnt.get();
        assert (refs >= 0L);
        return refs != 0L;
    }

    final synchronized long getBuffer(int idx) {
        return this.buffers.get(idx);
    }

    final synchronized int numBuffers() {
        return this.buffers.size();
    }

    private long newBuffer() {
        return this.dir.memory().allocate(32768L);
    }

    public void delete() {
        if (!this.deleted.compareAndSet(false, true)) {
            return;
        }
        this.deferredDelete();
    }

    synchronized void deferredDelete() {
        if (!this.deleted.get() || this.hasRefs()) {
            return;
        }
        assert (this.refCnt.get() == 0L);
        for (int i = 0; i < this.buffers.idx; ++i) {
            this.dir.memory().release(this.buffers.arr[i], 32768L);
        }
        this.buffers = null;
        this.dir.pendingDeletions.remove(this.name);
    }

    long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public GridLuceneDirectory getDirectory() {
        return this.dir;
    }

    public long ramBytesUsed() {
        return this.sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static class LongArray {
        private long[] arr = new long[128];
        private int idx;

        private LongArray() {
        }

        int size() {
            return this.idx;
        }

        long get(int idx) {
            assert (idx < this.idx);
            return this.arr[idx];
        }

        void add(long val) {
            int len = this.arr.length;
            if (this.idx == len) {
                this.arr = Arrays.copyOf(this.arr, Math.min(len * 2, len + 1024));
            }
            this.arr[this.idx++] = val;
        }
    }
}

