/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Objects;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.LuceneIndex;
import org.apache.ignite.internal.cache.query.LuceneIndexExtension;
import org.apache.ignite.internal.cache.query.LuceneIndexFactory;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneTextIndex;
import org.jetbrains.annotations.Nullable;

public class GridLuceneIndexFactory
implements LuceneIndexFactory {
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final LuceneIndexExtension luceneIndexExt;

    public GridLuceneIndexFactory(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(GridLuceneIndexFactory.class);
        this.luceneIndexExt = this.loadLuceneIndexExtension(ctx);
    }

    private LuceneIndexExtension loadLuceneIndexExtension(GridKernalContext ctx) {
        LuceneIndexExtension[] ext;
        if (Objects.nonNull(ctx.plugins()) && Objects.nonNull(ext = (LuceneIndexExtension[])ctx.plugins().extensions(LuceneIndexExtension.class))) {
            if (ext.length > 1) {
                this.log.info("More than one LuceneIndex extension is defined.");
            }
            return ext[0];
        }
        return null;
    }

    public LuceneIndex createIndex(@Nullable String cacheName, GridQueryTypeDescriptor type) throws IgniteException {
        if (this.luceneIndexExt != null) {
            return this.luceneIndexExt.createIndex(this.ctx, cacheName, type);
        }
        return new GridLuceneTextIndex(this.ctx, cacheName, type);
    }
}

