/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.log4j;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.logger.LoggerNodeIdAndApplicationAware;
import org.apache.ignite.logger.log4j.Log4jFileAware;
import org.apache.ignite.logger.log4j.Log4jNodeIdFilePath;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.Nullable;

public class Log4JLogger
implements IgniteLogger,
LoggerNodeIdAndApplicationAware,
Log4jFileAware {
    private static Collection<FileAppender> fileAppenders = new GridConcurrentHashSet();
    private static volatile boolean inited;
    private static volatile boolean quiet0;
    private static final Object mux;
    @GridToStringExclude
    private Logger impl;
    @GridToStringExclude
    private final String cfg;
    private final boolean quiet;
    @GridToStringExclude
    private UUID nodeId;

    public Log4JLogger() {
        this(!Log4JLogger.isConfigured());
    }

    public Log4JLogger(boolean init) {
        this.impl = Logger.getRootLogger();
        if (init) {
            this.addConsoleAppenderIfNeeded(Level.INFO, null);
            this.quiet = quiet0;
        } else {
            this.quiet = true;
        }
        this.cfg = null;
    }

    public Log4JLogger(final Logger impl) {
        assert (impl != null);
        this.addConsoleAppenderIfNeeded(null, (IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                return impl;
            }
        });
        this.quiet = quiet0;
        this.cfg = null;
    }

    private Log4JLogger(final Logger impl, String path) {
        assert (impl != null);
        this.addConsoleAppenderIfNeeded(null, (IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                return impl;
            }
        });
        this.quiet = quiet0;
        this.cfg = path;
    }

    public Log4JLogger(String path) throws IgniteCheckedException {
        this(path, 60000L);
    }

    public Log4JLogger(String path, final long watchDelay) throws IgniteCheckedException {
        if (path == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        if (watchDelay < 0L) {
            throw new IgniteCheckedException("watchDelay can't be negative: " + watchDelay);
        }
        this.cfg = path;
        final File cfgFile = U.resolveIgnitePath((String)path);
        if (cfgFile == null) {
            throw new IgniteCheckedException("Log4j configuration path was not found: " + path);
        }
        this.addConsoleAppenderIfNeeded(null, (IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    if (watchDelay > 0L) {
                        DOMConfigurator.configureAndWatch((String)cfgFile.getPath(), (long)watchDelay);
                    } else {
                        DOMConfigurator.configure((String)cfgFile.getPath());
                    }
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public Log4JLogger(File cfgFile) throws IgniteCheckedException {
        this(cfgFile, 60000L);
    }

    public Log4JLogger(final File cfgFile, final long watchDelay) throws IgniteCheckedException {
        if (cfgFile == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        if (!cfgFile.exists() || cfgFile.isDirectory()) {
            throw new IgniteCheckedException("Log4j configuration path was not found or is a directory: " + cfgFile);
        }
        if (watchDelay < 0L) {
            throw new IgniteCheckedException("watchDelay can't be negative: " + watchDelay);
        }
        this.cfg = cfgFile.getAbsolutePath();
        this.addConsoleAppenderIfNeeded(null, (IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    if (watchDelay > 0L) {
                        DOMConfigurator.configureAndWatch((String)cfgFile.getPath(), (long)watchDelay);
                    } else {
                        DOMConfigurator.configure((String)cfgFile.getPath());
                    }
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public Log4JLogger(URL cfgUrl) throws IgniteCheckedException {
        this(cfgUrl, 60000L);
    }

    public Log4JLogger(URL cfgUrl, final long watchDelay) throws IgniteCheckedException {
        if (cfgUrl == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        if (watchDelay < 0L) {
            throw new IgniteCheckedException("watchDelay can't be negative: " + watchDelay);
        }
        this.cfg = cfgUrl.getPath();
        this.addConsoleAppenderIfNeeded(null, (IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    if (watchDelay > 0L) {
                        DOMConfigurator.configureAndWatch((String)Log4JLogger.this.cfg, (long)watchDelay);
                    } else {
                        DOMConfigurator.configure((String)Log4JLogger.this.cfg);
                    }
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public static boolean isConfigured() {
        return Logger.getRootLogger().getAllAppenders().hasMoreElements();
    }

    public void setLevel(Level level) {
        this.impl.setLevel(level);
    }

    @Nullable
    public String fileName() {
        FileAppender fapp = (FileAppender)F.first(fileAppenders);
        return fapp != null ? fapp.getFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsoleAppenderIfNeeded(@Nullable Level logLevel, @Nullable IgniteClosure<Boolean, Logger> implInitC) {
        if (inited) {
            if (implInitC != null) {
                this.impl = (Logger)implInitC.apply((Object)false);
            }
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (inited) {
                if (implInitC != null) {
                    this.impl = (Logger)implInitC.apply((Object)false);
                }
                return;
            }
            if (implInitC != null) {
                this.impl = (Logger)implInitC.apply((Object)true);
            }
            boolean quiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "false"));
            boolean consoleAppenderFound = false;
            Logger rootCategory = null;
            ConsoleAppender errAppender = null;
            for (Logger l = this.impl; l != null; l = l.getParent()) {
                if (!consoleAppenderFound) {
                    Enumeration appenders = l.getAllAppenders();
                    while (appenders.hasMoreElements()) {
                        Appender appender = (Appender)appenders.nextElement();
                        if (!(appender instanceof ConsoleAppender)) continue;
                        if ("CONSOLE_ERR".equals(appender.getName())) {
                            errAppender = (ConsoleAppender)appender;
                            continue;
                        }
                        consoleAppenderFound = true;
                        break;
                    }
                }
                if (l.getParent() != null) continue;
                rootCategory = l;
                break;
            }
            if (consoleAppenderFound && quiet) {
                quiet = false;
            }
            if (!consoleAppenderFound && !quiet && Boolean.valueOf(System.getProperty("IGNITE_CONSOLE_APPENDER", "true")).booleanValue()) {
                assert (rootCategory != null);
                if (errAppender != null) {
                    rootCategory.addAppender(this.createConsoleAppender(Level.INFO));
                    if (errAppender.getThreshold() == Level.ERROR) {
                        errAppender.setThreshold((Priority)Level.WARN);
                    }
                } else {
                    rootCategory.addAppender(this.createConsoleAppender(Level.OFF));
                }
                if (logLevel != null) {
                    this.impl.setLevel(logLevel);
                }
            }
            if (!Log4JLogger.isConfigured()) {
                this.impl.setLevel(Level.OFF);
            }
            quiet0 = quiet;
            inited = true;
        }
    }

    private Appender createConsoleAppender(Level maxLevel) {
        String fmt = "[%d{ISO8601}][%-5p][%t][%c{1}] %m%n";
        ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout(fmt), "System.out");
        LevelRangeFilter lvlFilter = new LevelRangeFilter();
        lvlFilter.setLevelMin(Level.TRACE);
        lvlFilter.setLevelMax(maxLevel);
        app.addFilter((Filter)lvlFilter);
        return app;
    }

    public static void addAppender(FileAppender a) {
        A.notNull((Object)a, (String)"a");
        fileAppenders.add(a);
    }

    public static void removeAppender(FileAppender a) {
        A.notNull((Object)a, (String)"a");
        fileAppenders.remove(a);
    }

    public void setApplicationAndNode(@Nullable String application, UUID nodeId) {
        A.notNull((Object)nodeId, (String)"nodeId");
        this.nodeId = nodeId;
        this.updateFilePath(new Log4jNodeIdFilePath(application, nodeId));
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public static Collection<String> logFiles() {
        ArrayList<String> res = new ArrayList<String>(fileAppenders.size());
        for (FileAppender a : fileAppenders) {
            res.add(a.getFile());
        }
        return res;
    }

    public Log4JLogger getLogger(Object ctgr) {
        return new Log4JLogger(ctgr == null ? Logger.getRootLogger() : (ctgr instanceof Class ? Logger.getLogger((String)((Class)ctgr).getName()) : Logger.getLogger((String)ctgr.toString())), this.cfg);
    }

    public void trace(String msg) {
        if (!this.impl.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace((Object)msg);
    }

    public void debug(String msg) {
        if (!this.impl.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug((Object)msg);
    }

    public void info(String msg) {
        if (!this.impl.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info((Object)msg);
    }

    public void warning(String msg) {
        this.impl.warn((Object)msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.impl.warn((Object)msg, e);
    }

    public void error(String msg) {
        this.impl.error((Object)msg);
    }

    public void error(String msg, @Nullable Throwable e) {
        this.impl.error((Object)msg, e);
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String toString() {
        return S.toString(Log4JLogger.class, (Object)this, (String)"config", (Object)this.cfg);
    }

    @Override
    public void updateFilePath(IgniteClosure<String, String> filePathClos) {
        A.notNull(filePathClos, (String)"filePathClos");
        for (FileAppender a : fileAppenders) {
            if (!(a instanceof Log4jFileAware)) continue;
            ((Log4jFileAware)a).updateFilePath(filePathClos);
            a.activateOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup() {
        Object object = mux;
        synchronized (object) {
            if (inited) {
                LogManager.shutdown();
            }
            inited = false;
        }
    }

    static {
        mux = new Object();
    }
}

