/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.jdbc.ClientSyncResultSet;
import org.apache.ignite.internal.jdbc.JdbcExceptionMapperUtil;
import org.apache.ignite.internal.jdbc.JdbcResultSetMetadata;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.jetbrains.annotations.Nullable;

public class JdbcResultSet
implements ResultSet {
    private static final String UPDATES_ARE_NOT_SUPPORTED = "Updates are not supported.";
    private static final String SQL_STRUCTURED_TYPE_ARE_NOT_SUPPORTED = "SQL structured type are not supported.";
    private static final String SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED = "SQL-specific types are not supported.";
    private static final BigDecimal MIN_DOUBLE = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private final ClientSyncResultSet rs;
    private final ResultSetMetadata rsMetadata;
    private final Supplier<ZoneId> zoneIdSupplier;
    @Nullable
    private final Statement statement;
    private final JdbcResultSetMetadata jdbcMeta;
    private final int maxRows;
    private boolean closeOnCompletion;
    private int fetchSize;
    @Nullable
    private SqlRow currentRow;
    private int currentPosition;
    boolean closed;
    private boolean wasNull;

    JdbcResultSet(ClientSyncResultSet rs, @Nullable Statement statement, Supplier<ZoneId> zoneIdSupplier, boolean closeOnCompletion, int maxRows) {
        this.rs = rs;
        this.rsMetadata = rs.metadata();
        this.zoneIdSupplier = zoneIdSupplier;
        this.statement = statement;
        this.currentRow = null;
        this.closed = false;
        this.wasNull = false;
        this.jdbcMeta = new JdbcResultSetMetadata(this.rsMetadata);
        this.closeOnCompletion = closeOnCompletion;
        this.maxRows = maxRows;
    }

    ClientSyncResultSet resultSet() {
        return this.rs;
    }

    @Nullable
    JdbcResultSet tryNextResultSet() throws SQLException {
        ClientSyncResultSet clientResultSet;
        if (!this.rs.hasNextResultSet()) {
            return null;
        }
        assert (this.statement != null);
        try {
            clientResultSet = this.rs.nextResultSet();
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(e);
        }
        JdbcStatement jdbcStatement = this.statement.unwrap(JdbcStatement.class);
        boolean closeOnCompletion = jdbcStatement.closeOnCompletion;
        return new JdbcResultSet(clientResultSet, this.statement, this.zoneIdSupplier, closeOnCompletion, this.maxRows);
    }

    boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    void setCloseStatement(boolean close) {
        this.closeOnCompletion = close;
    }

    private boolean hasNext() {
        return this.rs.hasNext() && (this.maxRows == 0 || this.currentPosition < this.maxRows);
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureNotClosed();
        try {
            if (!this.hasNext()) {
                this.currentRow = null;
                return false;
            }
            this.currentRow = (SqlRow)this.rs.next();
            ++this.currentPosition;
            return true;
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean moreResultSets = this.rs.hasNextResultSet();
        try {
            this.rs.close();
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(e);
        }
        finally {
            if (this.closeOnCompletion && !moreResultSets) {
                JdbcStatement statement2 = this.statement.unwrap(JdbcStatement.class);
                statement2.closeIfAllResultsClosed();
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureNotClosed();
        return this.wasNull;
    }

    @Override
    @Nullable
    public String getString(int colIdx) throws SQLException {
        this.ensureNotClosed();
        this.ensureHasCurrentRow();
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        try {
            switch (columnType) {
                case DATE: {
                    return Formatters.formatDate((LocalDate)val);
                }
                case TIME: {
                    return Formatters.formatTime((LocalTime)val, this.getColumnPrecision(colIdx));
                }
                case DATETIME: {
                    return Formatters.formatDateTime((LocalDateTime)val, this.getColumnPrecision(colIdx));
                }
                case TIMESTAMP: {
                    LocalDateTime localDateTime = this.instantWithLocalTimeZone((Instant)val);
                    return Formatters.formatDateTime(localDateTime, this.getColumnPrecision(colIdx));
                }
                case BYTE_ARRAY: {
                    return StringUtils.toHexString((byte[])((byte[])val));
                }
            }
            return String.valueOf(val);
        }
        catch (Exception e) {
            throw JdbcResultSet.conversionError("string", e);
        }
    }

    @Override
    @Nullable
    public String getString(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getString(colIdx);
    }

    @Override
    public boolean getBoolean(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return false;
        }
        ColumnMetadata column = (ColumnMetadata)this.rsMetadata.columns().get(colIdx - 1);
        switch (column.type()) {
            case BOOLEAN: {
                return (Boolean)val;
            }
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                long num = ((Number)val).longValue();
                return num != 0L;
            }
            case STRING: {
                String str = (String)val;
                if ("0".equals(str)) {
                    return false;
                }
                if (!"1".equals(str)) break;
                return true;
            }
        }
        throw JdbcResultSet.conversionError("boolean", val);
    }

    @Override
    public boolean getBoolean(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBoolean(colIdx);
    }

    @Override
    public byte getByte(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (byte)1 : 0;
            }
            case INT8: {
                return (Byte)val;
            }
            case INT16: 
            case INT32: 
            case INT64: {
                return (byte)JdbcResultSet.getLongValue(((Number)val).longValue(), Byte.TYPE.getTypeName(), -128L, 127L);
            }
            case FLOAT: {
                return (byte)JdbcResultSet.getFloatValueAsLong(((Float)val).floatValue(), Byte.TYPE.getTypeName(), -128L, 127L);
            }
            case DOUBLE: {
                return (byte)JdbcResultSet.getDoubleValueAsLong((Double)val, Byte.TYPE.getTypeName(), -128L, 127L);
            }
            case DECIMAL: {
                return (byte)JdbcResultSet.getDecimalValueAsLong((BigDecimal)val, Byte.TYPE.getTypeName(), -128L, 127L);
            }
            case STRING: {
                try {
                    return Byte.parseByte(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Byte.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Byte.TYPE.getTypeName(), val);
    }

    @Override
    public byte getByte(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getByte(colIdx);
    }

    @Override
    public short getShort(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (short)1 : 0;
            }
            case INT8: {
                return ((Byte)val).byteValue();
            }
            case INT16: {
                return (Short)val;
            }
            case INT32: 
            case INT64: {
                return (short)JdbcResultSet.getLongValue(((Number)val).longValue(), Short.TYPE.getTypeName(), -32768L, 32767L);
            }
            case FLOAT: {
                return (short)JdbcResultSet.getFloatValueAsLong(((Float)val).floatValue(), Short.TYPE.getTypeName(), -32768L, 32767L);
            }
            case DOUBLE: {
                return (short)JdbcResultSet.getDoubleValueAsLong((Double)val, Short.TYPE.getTypeName(), -32768L, 32767L);
            }
            case DECIMAL: {
                return (short)JdbcResultSet.getDecimalValueAsLong((BigDecimal)val, Short.TYPE.getTypeName(), -32768L, 32767L);
            }
            case STRING: {
                try {
                    return Short.parseShort(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Short.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Short.TYPE.getTypeName(), val);
    }

    @Override
    public short getShort(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getShort(colIdx);
    }

    @Override
    public int getInt(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1 : 0;
            }
            case INT8: {
                return ((Byte)val).byteValue();
            }
            case INT16: {
                return ((Short)val).shortValue();
            }
            case INT32: {
                return (Integer)val;
            }
            case INT64: {
                return (int)JdbcResultSet.getLongValue(((Number)val).longValue(), Integer.TYPE.getTypeName(), Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case FLOAT: {
                return (int)JdbcResultSet.getFloatValueAsLong(((Float)val).floatValue(), Integer.TYPE.getTypeName(), Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case DOUBLE: {
                return (int)JdbcResultSet.getDoubleValueAsLong((Double)val, Integer.TYPE.getTypeName(), Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case DECIMAL: {
                return (int)JdbcResultSet.getDecimalValueAsLong((BigDecimal)val, Integer.TYPE.getTypeName(), Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case STRING: {
                try {
                    return Integer.parseInt(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Integer.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Integer.TYPE.getTypeName(), val);
    }

    @Override
    public int getInt(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getInt(colIdx);
    }

    @Override
    public long getLong(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0L;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1L : 0L;
            }
            case INT8: {
                return ((Byte)val).byteValue();
            }
            case INT16: {
                return ((Short)val).shortValue();
            }
            case INT32: {
                return ((Integer)val).intValue();
            }
            case INT64: {
                return (Long)val;
            }
            case FLOAT: {
                return JdbcResultSet.getFloatValueAsLong(((Float)val).floatValue(), Long.TYPE.getTypeName(), Long.MIN_VALUE, Long.MAX_VALUE);
            }
            case DOUBLE: {
                return JdbcResultSet.getDoubleValueAsLong((Double)val, Long.TYPE.getTypeName(), Long.MIN_VALUE, Long.MAX_VALUE);
            }
            case DECIMAL: {
                return JdbcResultSet.getDecimalValueAsLong((BigDecimal)val, Long.TYPE.getTypeName(), Long.MIN_VALUE, Long.MAX_VALUE);
            }
            case STRING: {
                try {
                    return Long.parseLong(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Long.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Long.TYPE.getTypeName(), val);
    }

    @Override
    public long getLong(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getLong(colIdx);
    }

    @Override
    public float getFloat(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0.0f;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: {
                return ((Number)val).floatValue();
            }
            case DOUBLE: {
                double num = (Double)val;
                if (num < -3.4028234663852886E38 || num > 3.4028234663852886E38) {
                    throw JdbcResultSet.conversionError(Float.TYPE.getTypeName(), val);
                }
                return (float)num;
            }
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)val;
                if (bd.doubleValue() < -3.4028234663852886E38 || bd.doubleValue() > 3.4028234663852886E38) {
                    throw JdbcResultSet.conversionError(Float.TYPE.getTypeName(), val);
                }
                return bd.floatValue();
            }
            case STRING: {
                try {
                    return Float.parseFloat(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Float.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Float.TYPE.getTypeName(), val);
    }

    @Override
    public float getFloat(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getFloat(colIdx);
    }

    @Override
    public double getDouble(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0.0;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: {
                return ((Number)val).doubleValue();
            }
            case DOUBLE: {
                return (Double)val;
            }
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)val;
                if (bd.compareTo(MIN_DOUBLE) < 0 || bd.compareTo(MAX_DOUBLE) > 0) {
                    throw JdbcResultSet.conversionError(Double.TYPE.getTypeName(), val);
                }
                return bd.doubleValue();
            }
            case STRING: {
                try {
                    return Double.parseDouble(val.toString());
                }
                catch (NumberFormatException e) {
                    throw JdbcResultSet.conversionError(Double.TYPE.getTypeName(), val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError(Double.TYPE.getTypeName(), val);
    }

    @Override
    public double getDouble(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDouble(colIdx);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(int colIdx, int scale) throws SQLException {
        BigDecimal val = this.getBigDecimal(colIdx);
        return val == null ? null : val.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return new BigDecimal(((Number)val).longValue());
            }
            case FLOAT: 
            case DOUBLE: {
                return new BigDecimal(((Number)val).doubleValue());
            }
            case DECIMAL: {
                return (BigDecimal)val;
            }
            case STRING: {
                try {
                    return new BigDecimal(val.toString());
                }
                catch (Exception e) {
                    throw JdbcResultSet.conversionError("BigDecimal", val, e);
                }
            }
        }
        throw JdbcResultSet.conversionError("BigDecimal", val);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(String colLb, int scale) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBigDecimal(colIdx, scale);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBigDecimal(colIdx);
    }

    @Override
    public byte @Nullable [] getBytes(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBytes(colIdx);
    }

    @Override
    public byte @Nullable [] getBytes(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case BYTE_ARRAY: {
                return (byte[])val;
            }
            case INT8: {
                return new byte[]{(Byte)val};
            }
            case INT16: {
                return ByteBuffer.allocate(2).putShort((Short)val).array();
            }
            case INT32: {
                return ByteBuffer.allocate(4).putInt((Integer)val).array();
            }
            case INT64: {
                return ByteBuffer.allocate(8).putLong((Long)val).array();
            }
            case FLOAT: {
                return ByteBuffer.allocate(4).putFloat(((Float)val).floatValue()).array();
            }
            case DOUBLE: {
                return ByteBuffer.allocate(8).putDouble((Double)val).array();
            }
            case STRING: {
                return ((String)val).getBytes(StandardCharsets.UTF_8);
            }
            case UUID: {
                ByteBuffer buf = ByteBuffer.allocate(16);
                buf.putLong(((UUID)val).getMostSignificantBits());
                buf.putLong(((UUID)val).getLeastSignificantBits());
                return buf.array();
            }
        }
        throw JdbcResultSet.conversionError("byte[]", val);
    }

    @Override
    @Nullable
    public Date getDate(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case TIME: {
                return new Date(Time.valueOf((LocalTime)val).getTime());
            }
            case DATE: {
                return Date.valueOf((LocalDate)val);
            }
            case DATETIME: {
                return Date.valueOf(((LocalDateTime)val).toLocalDate());
            }
            case TIMESTAMP: {
                LocalDateTime localDateTime = this.instantWithLocalTimeZone((Instant)val);
                return Date.valueOf(localDateTime.toLocalDate());
            }
        }
        throw JdbcResultSet.conversionError("date", val);
    }

    @Override
    @Nullable
    public Date getDate(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDate(colIdx);
    }

    @Override
    @Nullable
    public Date getDate(int colIdx, Calendar cal) throws SQLException {
        return this.getDate(colIdx);
    }

    @Override
    @Nullable
    public Date getDate(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDate(colIdx);
    }

    @Override
    @Nullable
    public Time getTime(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case TIME: {
                return Time.valueOf((LocalTime)val);
            }
            case DATE: {
                return new Time(Date.valueOf((LocalDate)val).getTime());
            }
            case DATETIME: {
                return Time.valueOf(((LocalDateTime)val).toLocalTime());
            }
            case TIMESTAMP: {
                LocalDateTime localDateTime = this.instantWithLocalTimeZone((Instant)val);
                LocalTime localTime = localDateTime.toLocalTime();
                return Time.valueOf(localTime);
            }
        }
        throw JdbcResultSet.conversionError("time", val);
    }

    @Override
    @Nullable
    public Time getTime(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTime(colIdx);
    }

    @Override
    @Nullable
    public Time getTime(int colIdx, Calendar cal) throws SQLException {
        return this.getTime(colIdx);
    }

    @Override
    @Nullable
    public Time getTime(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTime(colIdx);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        ColumnType columnType = this.getColumnType(colIdx);
        switch (columnType) {
            case TIME: {
                return new Timestamp(Time.valueOf((LocalTime)val).getTime());
            }
            case DATE: {
                return new Timestamp(Date.valueOf((LocalDate)val).getTime());
            }
            case DATETIME: {
                return Timestamp.valueOf((LocalDateTime)val);
            }
            case TIMESTAMP: {
                LocalDateTime localDateTime = this.instantWithLocalTimeZone((Instant)val);
                return Timestamp.valueOf(localDateTime);
            }
        }
        throw JdbcResultSet.conversionError("timestamp", val);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(int colIdx, Calendar cal) throws SQLException {
        return this.getTimestamp(colIdx);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTimestamp(colIdx);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTimestamp(colIdx);
    }

    @Override
    public InputStream getAsciiStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getAsciiStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getUnicodeStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getUnicodeStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getBinaryStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Stream are not supported.");
    }

    @Override
    public InputStream getBinaryStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    @Nullable
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Cursor name is not supported.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return this.jdbcMeta;
    }

    @Override
    public int findColumn(String colLb) throws SQLException {
        this.ensureNotClosed();
        try {
            int index = this.rsMetadata.indexOf(colLb);
            if (index >= 0) {
                return index + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("Column not found: " + colLb, "22000");
    }

    @Override
    public Reader getCharacterStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public Reader getCharacterStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureNotClosed();
        return this.currentRow == null && this.hasNext();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureNotClosed();
        boolean hasNext = this.hasNext();
        if (this.currentPosition == 0 && !hasNext) {
            return false;
        }
        return this.currentRow == null && !hasNext;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureNotClosed();
        return this.currentRow != null && this.currentPosition == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureNotClosed();
        return this.currentRow != null && !this.hasNext();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureNotClosed();
        return this.isAfterLast() ? 0 : this.currentPosition;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNull(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNull(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBoolean(int colIdx, boolean x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBoolean(String colLb, boolean x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateByte(int colIdx, byte x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateByte(String colLb, byte x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateShort(int colIdx, short x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateShort(String colLb, short x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateInt(int colIdx, int x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateInt(String colLb, int x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateLong(int colIdx, long x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateLong(String colLb, long x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateFloat(int colIdx, float x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateFloat(String colLb, float x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateDouble(int colIdx, double x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateDouble(String colLb, double x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBigDecimal(int colIdx, BigDecimal x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBigDecimal(String colLb, BigDecimal x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateString(int colIdx, String x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateString(String colLb, String x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBytes(int colIdx, byte[] x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBytes(String colLb, byte[] x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateDate(int colIdx, Date x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateDate(String colLb, Date x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateTime(int colIdx, Time x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateTime(String colLb, Time x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateTimestamp(int colIdx, Timestamp x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateTimestamp(String colLb, Timestamp x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(int colIdx, Object x, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(int colIdx, Object x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(String colLb, Object x, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(String colLb, Object x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void insertRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Row refreshing is not supported.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Row updates are not supported.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.ensureNotClosed();
        if (this.getConcurrency() == 1007) {
            throw new SQLException("The result set concurrency is CONCUR_READ_ONLY");
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureNotClosed();
        return this.statement;
    }

    @Override
    public Object getObject(int colIdx, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQL_STRUCTURED_TYPE_ARE_NOT_SUPPORTED);
    }

    @Override
    @Nullable
    public <T> T getObject(int colIdx, Class<T> targetCls) throws SQLException {
        this.ensureNotClosed();
        return (T)this.getObject0(colIdx, targetCls);
    }

    @Override
    @Nullable
    public <T> T getObject(String colLb, Class<T> type) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getObject(colIdx, type);
    }

    @Override
    @Nullable
    public Object getObject(int colIdx) throws SQLException {
        return this.getValue(colIdx);
    }

    @Override
    @Nullable
    public Object getObject(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getValue(colIdx);
    }

    @Override
    public Object getObject(String colLb, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(SQL_STRUCTURED_TYPE_ARE_NOT_SUPPORTED);
    }

    @Override
    public Ref getRef(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Ref getRef(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Blob getBlob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Blob getBlob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Clob getClob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Clob getClob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Array getArray(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Array getArray(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public URL getURL(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public URL getURL(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateRef(int colIdx, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateRef(String colLb, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int colIdx, Blob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String colLb, Blob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int colIdx, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String colLb, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int colIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String colLb, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int colIdx, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String colLb, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int colIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int colIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateArray(int colIdx, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateArray(String colLb, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public RowId getRowId(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public RowId getRowId(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateRowId(int colIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateRowId(String colLb, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.statement != null && this.statement.isClosed();
    }

    @Override
    public void updateNString(int colIdx, String val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNString(String colLb, String val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int colIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String colLb, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int colIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int colIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public NClob getNClob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public NClob getNClob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateSQLXML(int colIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateSQLXML(String colLb, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    @Nullable
    public String getNString(int colIdx) throws SQLException {
        return this.getString(colIdx);
    }

    @Override
    public String getNString(String colLb) throws SQLException {
        return this.getString(colLb);
    }

    @Override
    public Reader getNCharacterStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Reader getNCharacterStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int colIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int colIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(UPDATES_ARE_NOT_SUPPORTED);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Result set is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcResultSet.class);
    }

    @Nullable
    Object getValue(int colIdx) throws SQLException {
        this.ensureNotClosed();
        this.ensureHasCurrentRow();
        if (colIdx < 1 || colIdx > this.rsMetadata.columns().size()) {
            throw new SQLException("Invalid column index: " + colIdx, "22000");
        }
        try {
            assert (this.currentRow != null);
            Object val = this.currentRow.value(colIdx - 1);
            this.wasNull = val == null;
            return val;
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException("Unable to value for column: " + colIdx, e);
        }
    }

    private void ensureHasCurrentRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("Result set is not positioned on a row.");
        }
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Result set is closed.", "24000");
        }
    }

    @Nullable
    private Object getObject0(int colIdx, Class<?> targetCls) throws SQLException {
        if (targetCls == Boolean.class) {
            boolean value = this.getBoolean(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == Byte.class) {
            byte value = this.getByte(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == Short.class) {
            short value = this.getShort(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == Integer.class) {
            int value = this.getInt(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == Long.class) {
            long value = this.getLong(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == Float.class) {
            float value = this.getFloat(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return Float.valueOf(value);
        }
        if (targetCls == Double.class) {
            double value = this.getDouble(colIdx);
            if (this.wasNull()) {
                return null;
            }
            return value;
        }
        if (targetCls == String.class) {
            return this.getString(colIdx);
        }
        if (targetCls == BigDecimal.class) {
            return this.getBigDecimal(colIdx);
        }
        if (targetCls == Date.class) {
            return this.getDate(colIdx);
        }
        if (targetCls == Time.class) {
            return this.getTime(colIdx);
        }
        if (targetCls == Timestamp.class) {
            return this.getTimestamp(colIdx);
        }
        if (targetCls == byte[].class) {
            return this.getBytes(colIdx);
        }
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (targetCls.isAssignableFrom(cls)) {
            return val;
        }
        throw JdbcResultSet.conversionError(targetCls.getTypeName(), val);
    }

    private ColumnType getColumnType(int colIdx) {
        ColumnMetadata column = (ColumnMetadata)this.rsMetadata.columns().get(colIdx - 1);
        return column.type();
    }

    private int getColumnPrecision(int colIdx) {
        int precision = ((ColumnMetadata)this.rsMetadata.columns().get(colIdx - 1)).precision();
        assert (precision <= 9) : "Precision is out of range. Precision: " + precision + ". Column: " + colIdx;
        return precision;
    }

    private static long getLongValue(long val, String typeName, long min, long max) throws SQLException {
        if (val < min || val > max) {
            throw JdbcResultSet.conversionError(typeName, val);
        }
        return val;
    }

    private static long getFloatValueAsLong(float val, String typeName, long min, long max) throws SQLException {
        if (val < (float)min || val > (float)max || Float.isInfinite(val) || Float.isNaN(val)) {
            throw JdbcResultSet.conversionError(typeName, Float.valueOf(val));
        }
        return (long)val;
    }

    private static long getDoubleValueAsLong(double val, String typeName, long min, long max) throws SQLException {
        if (val < (double)min || val > (double)max || Double.isInfinite(val) || Double.isNaN(val)) {
            throw JdbcResultSet.conversionError(typeName, val);
        }
        return (long)val;
    }

    private static long getDecimalValueAsLong(BigDecimal num, String typeName, long min, long max) throws SQLException {
        boolean failed;
        long val;
        BigDecimal intNum = num.setScale(0, RoundingMode.DOWN);
        try {
            val = intNum.longValueExact();
            failed = false;
        }
        catch (ArithmeticException e) {
            failed = true;
            val = 0L;
        }
        if (failed || val < min || val > max) {
            throw JdbcResultSet.conversionError(typeName, num);
        }
        return val;
    }

    private static SQLException conversionError(String typeName, Object val) {
        return JdbcResultSet.conversionError(typeName, val, null);
    }

    private static SQLException conversionError(String typeName, Object val, @Nullable Throwable cause) {
        return new SQLException(IgniteStringFormatter.format((String)"Cannot convert to {}: {}", (Object[])new Object[]{typeName, val}), "0700B", cause);
    }

    private LocalDateTime instantWithLocalTimeZone(Instant val) {
        ZoneId zoneId = this.zoneIdSupplier.get();
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return LocalDateTime.ofInstant(val, zoneId);
    }

    private static class Formatters {
        static final DateTimeFormatter TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
        static final DateTimeFormatter DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
        static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

        private Formatters() {
        }

        static String formatTime(LocalTime value, int precision) {
            return Formatters.formatWithPrecision(TIME, value, precision);
        }

        static String formatDateTime(LocalDateTime value, int precision) {
            return Formatters.formatWithPrecision(DATE_TIME, value, precision);
        }

        static String formatDate(LocalDate value) {
            return DATE.format(value);
        }

        private static String formatWithPrecision(DateTimeFormatter formatter, TemporalAccessor value, int precision) {
            StringBuilder sb = new StringBuilder();
            formatter.formatTo(value, sb);
            if (precision <= 0) {
                return sb.toString();
            }
            long nanos = value.getLong(ChronoField.NANO_OF_SECOND);
            long scaled = nanos / (long)Math.pow(10.0, 9 - precision);
            sb.append('.');
            for (int i = 0; i < precision; ++i) {
                sb.append('0');
            }
            int pos = precision - 1;
            int start = sb.length() - precision;
            do {
                int digit = (int)(scaled % 10L);
                char c = (char)(48 + digit);
                sb.setCharAt(start + pos, c);
            } while ((scaled /= 10L) != 0L && --pos >= 0);
            return sb.toString();
        }
    }
}

