/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcExceptionMapperUtil;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.apache.ignite.internal.jdbc.ResultSetWrapper;
import org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlBatchException;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private static final Set<JDBCType> SUPPORTED_TYPES = EnumSet.of(JDBCType.BOOLEAN, new JDBCType[]{JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.FLOAT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DATE, JDBCType.TIME, JDBCType.TIMESTAMP, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.NULL, JDBCType.OTHER});
    private static final String SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED = "SQL-specific types are not supported.";
    private static final String STREAMS_ARE_NOT_SUPPORTED = "Streams are not supported.";
    private static final String CONVERSION_TO_TARGET_SQL_TYPE_IS_NOT_SUPPORTED = "Conversion to target sql type is not supported.";
    private static final String PARAMETER_METADATA_IS_NOT_SUPPORTED = "Parameter metadata is not supported.";
    private static final String RESULT_SET_METADATA_IS_NOT_SUPPORTED = "ResultSet metadata for prepared statement is not supported.";
    private final String sql;
    private List<Object> currentArguments = List.of();
    @Nullable
    private BatchedArguments batchedArgs;

    JdbcPreparedStatement(Connection connection, IgniteSql igniteSql, String schema, int resHoldability, String sql, int queryTimeoutSeconds) {
        super(connection, igniteSql, schema, resHoldability, queryTimeoutSeconds);
        this.sql = sql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute0(QUERY, this.sql, this.currentArguments.toArray());
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + this.sql, "42000");
        }
        return rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("The method 'executeQuery(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        CancelHandle handle;
        this.ensureNotClosed();
        if (CollectionUtils.nullOrEmpty((Iterable)this.batchedArgs)) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        JdbcConnection conn = this.connection.unwrap(JdbcConnection.class);
        Transaction tx = conn.startTransactionIfNoAutoCommit();
        this.cancelHandle = handle = CancelHandle.create();
        Statement igniteStmt = this.createIgniteStatement(this.sql);
        ClientSql clientSql = (ClientSql)this.igniteSql;
        try {
            long[] longUpdateCounters = clientSql.executeBatch(tx, handle.token(), igniteStmt, this.batchedArgs);
            int[] nArray = JdbcPreparedStatement.longsArrayToIntsArrayUnsafe(longUpdateCounters);
            return nArray;
        }
        catch (SqlBatchException e) {
            throw new BatchUpdateException(e.getMessage(), IgniteQueryErrorCode.codeToSqlState((int)e.errorCode()), 1, JdbcPreparedStatement.longsArrayToIntsArrayUnsafe(e.updateCounters()));
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(e);
        }
        finally {
            this.batchedArgs = null;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute0(DML_OR_DDL, this.sql, this.currentArguments.toArray());
        int res = this.getUpdateCount();
        if (res == -1) {
            throw new SQLException("The query is not DML statement: " + this.sql, "42000");
        }
        return res;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, String[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, int[] colNames) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute() throws SQLException {
        this.execute0(ALL, this.sql, this.currentArguments.toArray());
        ResultSetWrapper rs = this.result;
        assert (rs != null);
        return rs.isQuery();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("The method 'execute(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("The method 'execute(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, int[] colNames) throws SQLException {
        throw new SQLException("The method 'execute(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        throw new SQLException("The method 'execute(String, String[]) is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureNotClosed();
        if (this.currentArguments.isEmpty()) {
            return;
        }
        if (this.batchedArgs == null) {
            this.batchedArgs = BatchedArguments.create();
        }
        this.batchedArgs.add(this.currentArguments.toArray());
        this.currentArguments = List.of();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("The method 'addBatch(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batchedArgs = null;
    }

    @Override
    public void setNull(int paramIdx, int sqlType) throws SQLException {
        this.ensureNotClosed();
        JdbcPreparedStatement.checkType(sqlType);
        this.setArgumentValue(paramIdx, null);
    }

    @Override
    public void setNull(int paramIdx, int sqlType, String typeName) throws SQLException {
        this.ensureNotClosed();
        JdbcPreparedStatement.checkType(sqlType);
        this.setArgumentValue(paramIdx, null);
    }

    @Override
    public void setBoolean(int paramIdx, boolean x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setByte(int paramIdx, byte x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setShort(int paramIdx, short x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setInt(int paramIdx, int x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setLong(int paramIdx, long x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setFloat(int paramIdx, float x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, Float.valueOf(x));
    }

    @Override
    public void setDouble(int paramIdx, double x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    @Override
    public void setBigDecimal(int paramIdx, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 3);
        } else {
            this.ensureNotClosed();
            this.setArgumentValue(paramIdx, x);
        }
    }

    @Override
    public void setString(int paramIdx, String x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 12);
        } else {
            this.ensureNotClosed();
            this.setArgumentValue(paramIdx, x);
        }
    }

    @Override
    public void setBytes(int paramIdx, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, -3);
        } else {
            this.ensureNotClosed();
            this.setArgumentValue(paramIdx, x);
        }
    }

    @Override
    public void setDate(int paramIdx, Date x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 91);
        } else {
            this.setLocalDate(paramIdx, x.toLocalDate());
        }
    }

    @Override
    public void setDate(int paramIdx, Date x, Calendar cal) throws SQLException {
        this.setDate(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 92);
        } else {
            this.setLocalTime(paramIdx, x.toLocalTime());
        }
    }

    @Override
    public void setTime(int paramIdx, Time x, Calendar cal) throws SQLException {
        this.setTime(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 93);
        } else {
            this.setLocalDateTime(paramIdx, x.toLocalDateTime());
        }
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setUnicodeStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureNotClosed();
        this.currentArguments = List.of();
    }

    @Override
    public void setObject(int paramIdx, Object x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(paramIdx, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(paramIdx, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(paramIdx, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(paramIdx, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(paramIdx, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(paramIdx, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(paramIdx, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(paramIdx, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(paramIdx, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(paramIdx, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(paramIdx, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(paramIdx, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(paramIdx, (Timestamp)x);
        } else if (x instanceof LocalTime) {
            this.setLocalTime(paramIdx, (LocalTime)x);
        } else if (x instanceof LocalDate) {
            this.setLocalDate(paramIdx, (LocalDate)x);
        } else if (x instanceof LocalDateTime) {
            this.setLocalDateTime(paramIdx, (LocalDateTime)x);
        } else if (x instanceof Instant) {
            this.setInstant(paramIdx, (Instant)x);
        } else if (x instanceof UUID) {
            this.setUuid(paramIdx, (UUID)x);
        } else {
            throw new SQLException("Parameter type is not supported: " + x.getClass().getName());
        }
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CONVERSION_TO_TARGET_SQL_TYPE_IS_NOT_SUPPORTED);
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CONVERSION_TO_TARGET_SQL_TYPE_IS_NOT_SUPPORTED);
    }

    @Override
    public void setObject(int paramIdx, Object x, SQLType targetSqlType) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CONVERSION_TO_TARGET_SQL_TYPE_IS_NOT_SUPPORTED);
    }

    @Override
    public void setObject(int paramIdx, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CONVERSION_TO_TARGET_SQL_TYPE_IS_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setRef(int paramIdx, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int paramIdx, Blob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setClob(int paramIdx, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setArray(int paramIdx, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RESULT_SET_METADATA_IS_NOT_SUPPORTED);
    }

    @Override
    public void setURL(int paramIdx, URL x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(PARAMETER_METADATA_IS_NOT_SUPPORTED);
    }

    @Override
    public void setRowId(int paramIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setNString(int paramIdx, String val) throws SQLException {
        this.ensureNotClosed();
        this.setString(paramIdx, val);
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(STREAMS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int paramIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setSQLXML(int paramIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("executeLargeBatch not implemented.");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("executeLargeUpdate not implemented.");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("The method 'executeLargeUpdate(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("The method 'executeLargeUpdate(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("The method 'executeLargeUpdate(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("The method 'executeLargeUpdate(String, String[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(Objects.requireNonNull(iface))) {
            throw new SQLException("Prepared statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcPreparedStatement.class);
    }

    private void setLocalDate(int paramIdx, LocalDate x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    private void setLocalTime(int paramIdx, LocalTime x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    private void setLocalDateTime(int paramIdx, LocalDateTime x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    private void setInstant(int paramIdx, Instant x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    private void setUuid(int paramIdx, UUID x) throws SQLException {
        this.ensureNotClosed();
        this.setArgumentValue(paramIdx, x);
    }

    private void setArgumentValue(int paramIdx, @Nullable Object val) throws SQLException {
        if (paramIdx < 1) {
            throw new SQLException("Parameter index is invalid: " + paramIdx);
        }
        if (this.currentArguments.isEmpty()) {
            this.currentArguments = new ArrayList<Object>(paramIdx);
        }
        while (this.currentArguments.size() < paramIdx) {
            this.currentArguments.add(null);
        }
        this.currentArguments.set(paramIdx - 1, val);
    }

    List<Object> getArguments() {
        return this.currentArguments;
    }

    private static void checkType(int sqlType) throws SQLException {
        JDBCType jdbcType = JDBCType.valueOf(sqlType);
        if (!SUPPORTED_TYPES.contains(jdbcType)) {
            throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
        }
    }

    private static int[] longsArrayToIntsArrayUnsafe(long[] longs) {
        int[] ints = new int[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }
}

