/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.tx;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gridgain.shaded.org.apache.ignite.tx.RunInTransactionInternalImpl;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.apache.ignite.tx.TransactionException;
import org.gridgain.shaded.org.apache.ignite.tx.TransactionOptions;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public interface IgniteTransactions {
    default public Transaction begin() {
        return this.begin(null);
    }

    public Transaction begin(@Nullable TransactionOptions var1);

    default public CompletableFuture<Transaction> beginAsync() {
        return this.beginAsync(null);
    }

    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions var1);

    default public void runInTransaction(Consumer<Transaction> clo) throws TransactionException {
        this.runInTransaction(clo, null);
    }

    default public void runInTransaction(Consumer<Transaction> clo, @Nullable TransactionOptions options) throws TransactionException {
        Objects.requireNonNull(clo);
        this.runInTransaction((Transaction tx) -> {
            clo.accept((Transaction)tx);
            return null;
        }, options);
    }

    default public <T> T runInTransaction(Function<Transaction, T> clo) throws TransactionException {
        return this.runInTransaction(clo, null);
    }

    default public <T> T runInTransaction(Function<Transaction, T> clo, @Nullable TransactionOptions options) throws TransactionException {
        long startTimestamp = System.currentTimeMillis();
        long initialTimeout = options == null ? TimeUnit.SECONDS.toMillis(30L) : options.timeoutMillis();
        return RunInTransactionInternalImpl.runInTransactionInternal(this, clo, options, startTimestamp, initialTimeout);
    }

    default public <T> CompletableFuture<T> runInTransactionAsync(Function<Transaction, CompletableFuture<T>> clo) {
        return this.runInTransactionAsync(clo, null);
    }

    default public <T> CompletableFuture<T> runInTransactionAsync(Function<Transaction, CompletableFuture<T>> clo, @Nullable TransactionOptions options) {
        long startTimestamp = System.currentTimeMillis();
        long initialTimeout = options == null ? TimeUnit.SECONDS.toMillis(30L) : options.timeoutMillis();
        return RunInTransactionInternalImpl.runInTransactionAsyncInternal(this, clo, options, startTimestamp, initialTimeout, null);
    }
}

