/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private final Predicate<T> pred;
    private T cur;

    public FilteringIterator(Iterator<T> delegate, Predicate<T> pred) {
        this.delegate = delegate;
        this.pred = pred;
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.cur != null;
    }

    @Override
    public T next() {
        this.advance();
        if (this.cur == null) {
            throw new NoSuchElementException();
        }
        T tmp = this.cur;
        this.cur = null;
        return tmp;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    private void advance() {
        if (this.cur != null) {
            return;
        }
        while (this.delegate.hasNext() && this.cur == null) {
            this.cur = this.delegate.next();
            if (this.pred.test(this.cur)) continue;
            this.cur = null;
        }
    }
}

