/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.tostring;

import java.util.Arrays;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.CircularStringBuilder;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class StringBuilderLimitedLength
extends IgniteStringBuilder {
    private static final int MAX_STR_LEN = 10000;
    private static final int TAIL_LEN = 2000;
    private static final int HEAD_LEN = 8000;
    private CircularStringBuilder tail = null;

    StringBuilderLimitedLength(int cap) {
        super(cap);
    }

    public void reset() {
        this.setLength(0);
        if (this.tail != null) {
            this.tail.reset();
        }
    }

    @Nullable
    public CircularStringBuilder getTail() {
        return this.tail;
    }

    private StringBuilderLimitedLength onWrite() {
        if (!this.isOverflowed()) {
            return this;
        }
        if (this.tail == null) {
            this.tail = new CircularStringBuilder(2000);
        }
        if (this.tail.length() == 0) {
            int newSbLen = Math.min(this.length(), 8001);
            this.tail.append(this.impl().substring(newSbLen));
            this.setLength(newSbLen);
        }
        return this;
    }

    @Override
    public StringBuilderLimitedLength app(Object obj) {
        if (this.isOverflowed()) {
            this.tail.append(obj);
            return this;
        }
        super.app(obj);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(String str) {
        if (this.isOverflowed()) {
            this.tail.append(str);
            return this;
        }
        super.app(str);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(StringBuffer sb) {
        if (this.isOverflowed()) {
            this.tail.append(sb);
            return this;
        }
        super.app(sb);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(CharSequence s) {
        if (this.isOverflowed()) {
            this.tail.append(s);
            return this;
        }
        super.app(s);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(CharSequence s, int start, int end) {
        if (this.isOverflowed()) {
            this.tail.append(s.subSequence(start, end));
            return this;
        }
        super.app(s, start, end);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(char[] str) {
        if (this.isOverflowed()) {
            this.tail.append(str);
            return this;
        }
        super.app(str);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(char[] str, int offset, int len) {
        if (this.isOverflowed()) {
            this.tail.append(Arrays.copyOfRange(str, offset, len));
            return this;
        }
        super.app(str, offset, len);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(boolean b) {
        if (this.isOverflowed()) {
            this.tail.append(b);
            return this;
        }
        super.app(b);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(char c) {
        if (this.isOverflowed()) {
            this.tail.append(Character.valueOf(c));
            return this;
        }
        super.app(c);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(int i) {
        if (this.isOverflowed()) {
            this.tail.append(i);
            return this;
        }
        super.app(i);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(long lng) {
        if (this.isOverflowed()) {
            this.tail.append(lng);
            return this;
        }
        super.app(lng);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(float f) {
        if (this.isOverflowed()) {
            this.tail.append(Float.valueOf(f));
            return this;
        }
        super.app(f);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength app(double d) {
        if (this.isOverflowed()) {
            this.tail.append(d);
            return this;
        }
        super.app(d);
        return this.onWrite();
    }

    @Override
    public StringBuilderLimitedLength appendCodePoint(int codePoint) {
        if (this.isOverflowed()) {
            this.tail.append(codePoint);
            return this;
        }
        super.appendCodePoint(codePoint);
        return this.onWrite();
    }

    @Override
    public String toString() {
        if (this.tail == null) {
            return super.toString();
        }
        int tailLen = this.tail.length();
        StringBuilder res = new StringBuilder(this.impl().capacity() + tailLen + 100);
        res.append((CharSequence)this.impl());
        if (this.tail.getSkipped() > 0) {
            res.append("... and ").append(this.tail.getSkipped() + tailLen).append(" skipped ...");
        }
        res.append(this.tail.toString());
        return res.toString();
    }

    public boolean isOverflowed() {
        return this.impl().length() > 8000;
    }
}

