/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.logger;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.gridgain.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.gridgain.shaded.org.apache.ignite.internal.logger.IgniteLoggerImpl;
import org.gridgain.shaded.org.apache.ignite.internal.logger.IgniteThrottledLogger;
import org.gridgain.shaded.org.apache.ignite.internal.logger.IgniteThrottledLoggerImpl;
import org.gridgain.shaded.org.apache.ignite.internal.logger.VoidLogger;
import org.gridgain.shaded.org.apache.ignite.lang.LoggerFactory;

public final class Loggers {
    public static IgniteLogger forClass(Class<?> cls) {
        return Loggers.forName(Objects.requireNonNull(cls, "cls").getName());
    }

    public static IgniteLogger forClass(Class<?> cls, LoggerFactory loggerFactory) {
        return Loggers.forName(Objects.requireNonNull(cls, "cls").getName(), loggerFactory);
    }

    public static IgniteLogger forName(String name) {
        System.Logger delegate = System.getLogger(name);
        return new IgniteLoggerImpl(delegate);
    }

    public static IgniteLogger forName(String name, LoggerFactory loggerFactory) {
        System.Logger delegate = Objects.requireNonNull(loggerFactory, "loggerFactory").forName(name);
        return new IgniteLoggerImpl(delegate);
    }

    public static IgniteLogger voidLogger() {
        return VoidLogger.INSTANCE;
    }

    public static IgniteThrottledLogger toThrottledLogger(IgniteLogger logger, Executor executor) {
        assert (logger instanceof IgniteLoggerImpl) : logger;
        return new IgniteThrottledLoggerImpl(((IgniteLoggerImpl)logger).delegate, executor);
    }
}

