/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.continuousquery;

import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.internal.hlc.HybridTimestamp;
import org.gridgain.shaded.org.apache.ignite.table.TableRowEventType;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public final class RowUpdateInfo<T> {
    private final UUID rowUuid;
    private final HybridTimestamp timestamp;
    private final T row;
    private final T oldRow;
    private final HybridTimestamp commitTs;
    private final HybridTimestamp oldCommitTs;
    private final TableRowEventType eventType;

    public RowUpdateInfo(UUID rowUuid, HybridTimestamp timestamp, @Nullable T row, @Nullable T oldRow, HybridTimestamp commitTs, @Nullable HybridTimestamp oldCommitTs, TableRowEventType eventType) {
        assert (rowUuid != null) : "rowUuid != null";
        assert (timestamp != null) : "timestamp != null";
        assert (row != null || oldRow != null) : "row != null || oldRow != null";
        assert (commitTs != null) : "commitTs != null";
        this.rowUuid = rowUuid;
        this.timestamp = timestamp;
        this.row = row;
        this.oldRow = oldRow;
        this.commitTs = commitTs;
        this.oldCommitTs = oldCommitTs;
        this.eventType = eventType;
    }

    public UUID rowUuid() {
        return this.rowUuid;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Nullable
    public T row() {
        return this.row;
    }

    @Nullable
    public T oldRow() {
        return this.oldRow;
    }

    public HybridTimestamp commitTs() {
        return this.commitTs;
    }

    @Nullable
    public HybridTimestamp oldCommitTs() {
        return this.oldCommitTs;
    }

    public TableRowEventType eventType() {
        return this.eventType;
    }
}

