/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.compute;

import org.gridgain.shaded.org.apache.ignite.compute.JobStatus;
import org.gridgain.shaded.org.apache.ignite.compute.TaskState;
import org.gridgain.shaded.org.apache.ignite.compute.TaskStatus;
import org.gridgain.shaded.org.apache.ignite.internal.compute.JobStateImpl;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class JobTaskStatusMapper {
    @Nullable
    public static JobStateImpl toJobState(@Nullable TaskState taskState) {
        if (taskState == null) {
            return null;
        }
        return JobStateImpl.builder().id(taskState.id()).createTime(taskState.createTime()).startTime(taskState.startTime()).finishTime(taskState.finishTime()).status(JobTaskStatusMapper.toJobStatus(taskState.status())).build();
    }

    private static JobStatus toJobStatus(TaskStatus taskStatus) {
        switch (taskStatus) {
            case QUEUED: {
                return JobStatus.QUEUED;
            }
            case EXECUTING: {
                return JobStatus.EXECUTING;
            }
            case FAILED: {
                return JobStatus.FAILED;
            }
            case COMPLETED: {
                return JobStatus.COMPLETED;
            }
            case CANCELING: {
                return JobStatus.CANCELING;
            }
            case CANCELED: {
                return JobStatus.CANCELED;
            }
        }
        throw new IllegalArgumentException("Unknown task status.");
    }

    static TaskStatus toTaskStatus(JobStatus jobStatus) {
        switch (jobStatus) {
            case QUEUED: {
                return TaskStatus.QUEUED;
            }
            case EXECUTING: {
                return TaskStatus.EXECUTING;
            }
            case FAILED: {
                return TaskStatus.FAILED;
            }
            case COMPLETED: {
                return TaskStatus.COMPLETED;
            }
            case CANCELING: {
                return TaskStatus.CANCELING;
            }
            case CANCELED: {
                return TaskStatus.CANCELED;
            }
        }
        throw new IllegalArgumentException("Unknown job status.");
    }
}

