/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.sql;

import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientDirectTxMode;

public final class ClientPartitionAwarenessMetadata {
    private final int tableId;
    private final int[] indexes;
    private final int[] hash;
    private final ClientDirectTxMode directTxMode;

    private ClientPartitionAwarenessMetadata(int tableId, int[] indexes, int[] hash, ClientDirectTxMode directTxMode) {
        this.tableId = tableId;
        this.indexes = indexes;
        this.hash = hash;
        this.directTxMode = directTxMode;
    }

    static ClientPartitionAwarenessMetadata read(ClientMessageUnpacker unpacker, boolean sqlDirectMappingSupported) {
        int tableId = unpacker.unpackInt();
        int[] indexes = unpacker.unpackIntArray();
        int[] hash = unpacker.unpackIntArray();
        ClientDirectTxMode directTxMode = ClientDirectTxMode.NOT_SUPPORTED;
        if (sqlDirectMappingSupported) {
            directTxMode = ClientDirectTxMode.fromId(unpacker.unpackByte());
        }
        return new ClientPartitionAwarenessMetadata(tableId, indexes, hash, directTxMode);
    }

    public int tableId() {
        return this.tableId;
    }

    public int[] indexes() {
        return this.indexes;
    }

    public int[] hash() {
        return this.hash;
    }

    ClientDirectTxMode directTxMode() {
        return this.directTxMode;
    }
}

