/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.jdbc.ClientSyncResultSet;
import org.apache.ignite.internal.jdbc.ClientSyncResultSetImpl;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcExceptionMapperUtil;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.internal.jdbc.ResultSetWrapper;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientAsyncResultSet;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientSql;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.QueryModifier;
import org.gridgain.shaded.org.apache.ignite.internal.util.ArrayUtils;
import org.gridgain.shaded.org.apache.ignite.lang.CancelHandle;
import org.gridgain.shaded.org.apache.ignite.sql.IgniteSql;
import org.gridgain.shaded.org.apache.ignite.sql.Statement;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;
import org.gridgain.shaded.org.jetbrains.annotations.TestOnly;

public class JdbcStatement
implements java.sql.Statement {
    static final EnumSet<QueryModifier> QUERY = EnumSet.of(QueryModifier.ALLOW_ROW_SET_RESULT);
    static final EnumSet<QueryModifier> DML_OR_DDL = EnumSet.of(QueryModifier.ALLOW_AFFECTED_ROWS_RESULT, QueryModifier.ALLOW_APPLIED_RESULT);
    static final Set<QueryModifier> ALL = QueryModifier.ALL;
    private static final String RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED = "Returning auto-generated keys is not supported.";
    private static final String LARGE_UPDATE_NOT_SUPPORTED = "executeLargeUpdate not implemented.";
    private static final String FIELD_SIZE_LIMIT_IS_NOT_SUPPORTED = "Field size limit is not supported.";
    private static final String CURSOR_NAME_IS_NOT_SUPPORTED = "Setting cursor name is not supported.";
    private static final String MULTIPLE_OPEN_RESULTS_ARE_NOT_SUPPORTED = "Multiple open results are not supported.";
    private static final String POOLING_IS_NOT_SUPPORTED = "Pooling is not supported.";
    private static final String STATEMENT_IS_CLOSED = "Statement is closed.";
    private static final String ONLY_FORWARD_DIRECTION_IS_SUPPORTED = "Only forward direction is supported.";
    final Connection connection;
    final IgniteSql igniteSql;
    private final String schemaName;
    private final int rsHoldability;
    @Nullable
    protected volatile ResultSetWrapper result;
    private long queryTimeoutMillis;
    private int pageSize;
    private int maxRows = 0;
    private volatile boolean closed;
    boolean closeOnCompletion;
    @Nullable
    volatile CancelHandle cancelHandle;
    @Nullable
    private List<String> batch;

    JdbcStatement(Connection connection, IgniteSql igniteSql, String schemaName, int rsHoldability, int queryTimeoutSeconds) {
        this.connection = connection;
        this.schemaName = schemaName;
        this.igniteSql = igniteSql;
        this.rsHoldability = rsHoldability;
        this.queryTimeoutMillis = TimeUnit.SECONDS.toMillis(queryTimeoutSeconds);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute0(QUERY, Objects.requireNonNull(sql), ArrayUtils.OBJECT_EMPTY_ARRAY);
        ResultSetWrapper currentRs = this.result;
        assert (currentRs != null);
        JdbcResultSet rs = currentRs.current();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + sql, "42000");
        }
        return rs;
    }

    JdbcResultSet createResultSet(ClientSyncResultSet resultSet) throws SQLException {
        JdbcConnection jdbcConnection = this.connection.unwrap(JdbcConnection.class);
        ZoneId zoneId = jdbcConnection.properties().getConnectionTimeZone();
        return new JdbcResultSet(resultSet, this, () -> zoneId, this.closeOnCompletion, this.maxRows);
    }

    void execute0(Set<QueryModifier> queryModifiers, String sql, Object[] args) throws SQLException {
        CancelHandle handle;
        this.ensureNotClosed();
        this.closeResults();
        if (sql == null || sql.isEmpty()) {
            throw new SQLException("SQL query is empty.");
        }
        JdbcConnection connection2 = this.connection.unwrap(JdbcConnection.class);
        Transaction tx = connection2.startTransactionIfNoAutoCommit();
        Statement igniteStmt = this.createIgniteStatement(sql);
        ClientSql clientSql = (ClientSql)this.igniteSql;
        this.cancelHandle = handle = CancelHandle.create();
        try {
            ClientAsyncResultSet clientRs = (ClientAsyncResultSet)clientSql.executeAsyncInternal(tx, null, handle.token(), queryModifiers, igniteStmt, args).join();
            this.result = new ResultSetWrapper(this.createResultSet(new ClientSyncResultSetImpl(clientRs)));
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Objects.requireNonNull(sql, "sql");
        this.execute0(DML_OR_DDL, sql, ArrayUtils.OBJECT_EMPTY_ARRAY);
        ResultSetWrapper rs = this.result;
        assert (rs != null);
        if (rs.isQuery()) {
            this.closeResults();
            throw new SQLException("The query is not DML statement: " + sql);
        }
        return rs.updateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
            }
            case 2: {
                return this.executeUpdate(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value");
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.closeResults();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        if (max < 0) {
            throw new SQLException("Invalid field limit.");
        }
        throw new SQLFeatureNotSupportedException(FIELD_SIZE_LIMIT_IS_NOT_SUPPORTED);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        if (maxRows < 0) {
            throw new SQLException("Invalid max rows value.");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.queryTimeoutMillis);
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout value.");
        }
        this.queryTimeoutMillis = TimeUnit.SECONDS.toMillis(timeout);
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        CancelHandle handle = this.cancelHandle;
        if (handle != null) {
            handle.cancel();
        }
    }

    @Override
    @Nullable
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CURSOR_NAME_IS_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.ensureNotClosed();
        this.execute0(QueryModifier.ALL, Objects.requireNonNull(sql), ArrayUtils.OBJECT_EMPTY_ARRAY);
        ResultSetWrapper rs = this.result;
        assert (rs != null);
        return rs.isQuery();
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
            }
            case 2: {
                return this.execute(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value.");
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (colNames != null && colNames.length > 0) {
            throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
        }
        return this.execute(sql);
    }

    @Override
    @Nullable
    public ResultSet getResultSet() throws SQLException {
        this.ensureNotClosed();
        ResultSetWrapper rs = this.result;
        if (rs != null && rs.isQuery()) {
            return rs.current();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureNotClosed();
        ResultSetWrapper rs = this.result;
        if (rs == null) {
            return -1;
        }
        return rs.updateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureNotClosed();
        switch (current) {
            case 1: {
                ResultSetWrapper currentResult = this.result;
                if (currentResult == null) {
                    return false;
                }
                boolean moreResults = currentResult.nextResultSet();
                if (!moreResults) {
                    this.result = null;
                    return false;
                }
                return currentResult.isQuery();
            }
            case 2: 
            case 3: {
                throw new SQLFeatureNotSupportedException(MULTIPLE_OPEN_RESULTS_ARE_NOT_SUPPORTED);
            }
        }
        throw new SQLException("Invalid 'current' parameter.");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(LARGE_UPDATE_NOT_SUPPORTED);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(LARGE_UPDATE_NOT_SUPPORTED);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(LARGE_UPDATE_NOT_SUPPORTED);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException(ONLY_FORWARD_DIRECTION_IS_SUPPORTED);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize < 0) {
            throw new SQLException("Invalid fetch size.");
        }
        this.pageSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.pageSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(sql);
        if (sql.isBlank()) {
            return;
        }
        if (this.batch == null) {
            this.batch = new ArrayList<String>(2);
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        CancelHandle handle;
        this.ensureNotClosed();
        this.closeResults();
        if (this.batch == null) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        assert (!this.batch.isEmpty());
        String script = String.join((CharSequence)";", this.batch);
        Statement igniteStmt = this.createIgniteStatement(script);
        JdbcConnection conn = this.connection.unwrap(JdbcConnection.class);
        Transaction tx = conn.startTransactionIfNoAutoCommit();
        ClientSql clientSql = (ClientSql)this.igniteSql;
        this.cancelHandle = handle = CancelHandle.create();
        ArrayList<Integer> results = new ArrayList<Integer>(this.batch.size());
        try {
            ClientAsyncResultSet asyncRs = (ClientAsyncResultSet)clientSql.executeAsyncInternal(tx, null, handle.token(), EnumSet.of(QueryModifier.ALLOW_MULTISTATEMENT, QueryModifier.ALLOW_APPLIED_RESULT, QueryModifier.ALLOW_AFFECTED_ROWS_RESULT), igniteStmt, new Object[0]).get();
            while (true) {
                int affRows = asyncRs.affectedRows() == -1L ? -2 : (int)asyncRs.affectedRows();
                results.add(affRows);
                asyncRs.closeAsync();
                if (!asyncRs.hasNextResultSet()) break;
                asyncRs = asyncRs.nextResultSet().get();
            }
            int[] nArray = results.stream().mapToInt(Integer::intValue).toArray();
            return nArray;
        }
        catch (Exception e) {
            throw new BatchUpdateException(e.getMessage(), "50000", 1, results.stream().mapToInt(Integer::intValue).toArray());
        }
        finally {
            this.batch = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.rsHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException(POOLING_IS_NOT_SUPPORTED);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureNotClosed();
        this.closeOnCompletion = true;
        ResultSetWrapper rs = this.result;
        if (rs != null) {
            rs.setCloseStatement(true);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(Objects.requireNonNull(iface))) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcStatement.class);
    }

    @TestOnly
    public void timeout(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    Statement createIgniteStatement(String sql) throws SQLException {
        Statement.StatementBuilder builder = this.igniteSql.statementBuilder().query(sql).defaultSchema(this.schemaName);
        if (this.queryTimeoutMillis > 0L) {
            builder.queryTimeout(this.queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (this.getFetchSize() > 0) {
            builder.pageSize(this.getFetchSize());
        }
        JdbcConnection conn = this.connection.unwrap(JdbcConnection.class);
        ZoneId zoneId = conn.properties().getConnectionTimeZone();
        return builder.timeZoneId(zoneId).build();
    }

    void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_IS_CLOSED);
        }
    }

    private void closeResults() throws SQLException {
        ResultSetWrapper rs = this.result;
        this.result = null;
        if (rs != null) {
            rs.close();
        }
    }

    void closeIfAllResultsClosed() throws SQLException {
        if (!this.closeOnCompletion) {
            return;
        }
        this.close();
    }
}

