/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import org.apache.ignite.internal.jdbc.ClientSyncResultSet;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientAsyncResultSet;
import org.gridgain.shaded.org.apache.ignite.internal.sql.SyncResultSetAdapter;
import org.gridgain.shaded.org.apache.ignite.sql.ResultSetMetadata;
import org.gridgain.shaded.org.apache.ignite.sql.SqlRow;

final class ClientSyncResultSetImpl
implements ClientSyncResultSet {
    private final ClientAsyncResultSet<SqlRow> rs;
    private final SyncResultSetAdapter<SqlRow> syncRs;

    ClientSyncResultSetImpl(ClientAsyncResultSet<SqlRow> rs) {
        this.rs = rs;
        this.syncRs = new SyncResultSetAdapter<SqlRow>(rs);
    }

    @Override
    public ResultSetMetadata metadata() {
        ResultSetMetadata metadata = this.syncRs.metadata();
        return metadata != null ? metadata : EMPTY_METADATA;
    }

    @Override
    public boolean hasRowSet() {
        return this.syncRs.hasRowSet();
    }

    @Override
    public long affectedRows() {
        return this.syncRs.affectedRows();
    }

    @Override
    public boolean hasNextResultSet() {
        return this.rs.hasNextResultSet();
    }

    @Override
    public ClientSyncResultSet nextResultSet() {
        if (!this.rs.hasNextResultSet()) {
            throw new IllegalStateException("Should not have been called.");
        }
        ClientAsyncResultSet<SqlRow> nextRs = this.rs.nextResultSet().join();
        return new ClientSyncResultSetImpl(nextRs);
    }

    @Override
    public void close() {
        this.syncRs.close();
    }

    @Override
    public boolean hasNext() {
        return this.syncRs.hasNext();
    }

    @Override
    public SqlRow next() {
        return this.syncRs.next();
    }
}

