/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.jdbc.ClientSyncResultSet;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class JdbcUtils {
    private static final Supplier<ZoneId> defaultZoneSupplier = ZoneId::systemDefault;

    static ResultSet createObjectListResultSet(List<ColumnMetadata> columnsMeta) {
        return JdbcUtils.createObjectListResultSet(List.of(), columnsMeta, defaultZoneSupplier);
    }

    public static ResultSet createObjectListResultSet(List<List<Object>> rows, List<ColumnMetadata> columnsMeta, Supplier<ZoneId> timeZoneSupplier) {
        return JdbcUtils.createObjectListResultSet(rows, columnsMeta, timeZoneSupplier, 0);
    }

    public static ResultSet createObjectListResultSet(List<List<Object>> rows, List<ColumnMetadata> columnsMeta, Supplier<ZoneId> timeZoneSupplier, int maxRows) {
        ResultSetMetadataImpl meta = new ResultSetMetadataImpl(columnsMeta);
        TransformingIterator transformer = new TransformingIterator(rows.iterator(), arg_0 -> JdbcUtils.lambda$createObjectListResultSet$0((ResultSetMetadata)meta, rows, arg_0));
        return new JdbcResultSet(new IteratorBasedClientSyncResultSet((Iterator<SqlRow>)transformer, (ResultSetMetadata)meta), null, timeZoneSupplier, false, maxRows);
    }

    private static /* synthetic */ SqlRow lambda$createObjectListResultSet$0(ResultSetMetadata meta, List rows, List row) {
        assert (row.size() == meta.columns().size()) : "rows=" + rows.size() + ", meta=" + meta.columns().size();
        return new ObjectListToSqlRowAdapter(row);
    }

    private static class IteratorBasedClientSyncResultSet
    implements ClientSyncResultSet {
        private final ResultSetMetadata metadata;
        private final Iterator<SqlRow> rowsIterator;

        IteratorBasedClientSyncResultSet(Iterator<SqlRow> rowsIterator, ResultSetMetadata metadata) {
            this.rowsIterator = rowsIterator;
            this.metadata = metadata;
        }

        @Override
        public ResultSetMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean hasRowSet() {
            return true;
        }

        @Override
        public long affectedRows() {
            return -1L;
        }

        @Override
        public boolean hasNextResultSet() {
            return false;
        }

        @Override
        public ClientSyncResultSet nextResultSet() {
            throw new NoSuchElementException("Query has no more results");
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.rowsIterator.hasNext();
        }

        @Override
        public SqlRow next() {
            return this.rowsIterator.next();
        }
    }

    private static class ObjectListToSqlRowAdapter
    implements SqlRow {
        private final List<Object> row;

        ObjectListToSqlRowAdapter(List<Object> row) {
            this.row = row;
        }

        @Nullable
        public <T> T value(int columnIndex) {
            return (T)this.row.get(columnIndex);
        }

        @Nullable
        public <T> T value(String columnName) throws IllegalArgumentException {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public ResultSetMetadata metadata() {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public int columnCount() {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public String columnName(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public int columnIndex(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        @Nullable
        public <T> T valueOrDefault(String columnName, @Nullable T defaultValue) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public Tuple set(String columnName, @Nullable Object value) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public boolean booleanValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public boolean booleanValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public byte byteValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public byte byteValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public short shortValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public short shortValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public int intValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public int intValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public long longValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public long longValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public float floatValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public float floatValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public double doubleValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public double doubleValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public BigDecimal decimalValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public BigDecimal decimalValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public String stringValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public String stringValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public byte[] bytesValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public byte[] bytesValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public UUID uuidValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public UUID uuidValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalDate dateValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalDate dateValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalTime timeValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalTime timeValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalDateTime datetimeValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public LocalDateTime datetimeValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public Instant timestampValue(String columnName) {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        public Instant timestampValue(int columnIndex) {
            throw new UnsupportedOperationException("This method should not be called.");
        }
    }
}

