/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.sql;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Arrays;
import java.util.UUID;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public final class ColumnType
extends Enum<ColumnType> {
    public static final /* enum */ ColumnType NULL = new ColumnType(0, Void.class, false, false, false);
    public static final /* enum */ ColumnType BOOLEAN = new ColumnType(1, Boolean.class, false, false, false);
    public static final /* enum */ ColumnType INT8 = new ColumnType(2, Byte.class, false, false, false);
    public static final /* enum */ ColumnType INT16 = new ColumnType(3, Short.class, false, false, false);
    public static final /* enum */ ColumnType INT32 = new ColumnType(4, Integer.class, false, false, false);
    public static final /* enum */ ColumnType INT64 = new ColumnType(5, Long.class, false, false, false);
    public static final /* enum */ ColumnType FLOAT = new ColumnType(6, Float.class, false, false, false);
    public static final /* enum */ ColumnType DOUBLE = new ColumnType(7, Double.class, false, false, false);
    public static final /* enum */ ColumnType DECIMAL = new ColumnType(8, BigDecimal.class, true, true, false);
    public static final /* enum */ ColumnType DATE = new ColumnType(9, LocalDate.class, false, false, false);
    public static final /* enum */ ColumnType TIME = new ColumnType(10, LocalTime.class, true, false, false);
    public static final /* enum */ ColumnType DATETIME = new ColumnType(11, LocalDateTime.class, true, false, false);
    public static final /* enum */ ColumnType TIMESTAMP = new ColumnType(12, Instant.class, true, false, false);
    public static final /* enum */ ColumnType UUID = new ColumnType(13, UUID.class, false, false, false);
    public static final /* enum */ ColumnType STRING = new ColumnType(15, String.class, false, false, true);
    public static final /* enum */ ColumnType BYTE_ARRAY = new ColumnType(16, byte[].class, false, false, true);
    public static final /* enum */ ColumnType PERIOD = new ColumnType(17, Period.class, true, false, false);
    public static final /* enum */ ColumnType DURATION = new ColumnType(18, Duration.class, true, false, false);
    public static final /* enum */ ColumnType STRUCT = new ColumnType(19, Object.class, false, false, false);
    private final Class<?> javaClass;
    private final boolean precisionAllowed;
    private final boolean scaleAllowed;
    private final boolean lengthAllowed;
    private final int id;
    private static final ColumnType[] VALS;
    private static final /* synthetic */ ColumnType[] $VALUES;

    public static ColumnType[] values() {
        return (ColumnType[])$VALUES.clone();
    }

    public static ColumnType valueOf(String name) {
        return Enum.valueOf(ColumnType.class, name);
    }

    private ColumnType(int id, Class<?> clazz, boolean precisionDefined, boolean scaleDefined, boolean lengthDefined) {
        assert (!lengthDefined || !precisionDefined && !scaleDefined);
        this.javaClass = clazz;
        this.precisionAllowed = precisionDefined;
        this.scaleAllowed = scaleDefined;
        this.lengthAllowed = lengthDefined;
        this.id = id;
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public boolean precisionAllowed() {
        return this.precisionAllowed;
    }

    public boolean scaleAllowed() {
        return this.scaleAllowed;
    }

    public boolean lengthAllowed() {
        return this.lengthAllowed;
    }

    public int id() {
        return this.id;
    }

    @Nullable
    public static ColumnType getById(int id) {
        return id >= 0 && id < VALS.length ? VALS[id] : null;
    }

    private static /* synthetic */ ColumnType[] $values() {
        return new ColumnType[]{NULL, BOOLEAN, INT8, INT16, INT32, INT64, FLOAT, DOUBLE, DECIMAL, DATE, TIME, DATETIME, TIMESTAMP, UUID, STRING, BYTE_ARRAY, PERIOD, DURATION, STRUCT};
    }

    static {
        $VALUES = ColumnType.$values();
        int maxId = Arrays.stream(ColumnType.values()).mapToInt(ColumnType::id).max().orElse(0);
        ColumnType[] vals = new ColumnType[maxId + 1];
        for (ColumnType columnType : ColumnType.values()) {
            ColumnType existing = vals[columnType.id];
            assert (existing == null) : "Found duplicate id " + columnType.id;
            vals[columnType.id] = columnType;
        }
        VALS = vals;
    }
}

