/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.lang;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.gridgain.shaded.org.apache.ignite.lang.CancelHandleImpl;
import org.gridgain.shaded.org.apache.ignite.lang.CancellationToken;

public final class CancelHandleHelper {
    private CancelHandleHelper() {
    }

    public static void addCancelAction(CancellationToken token, Runnable cancelAction, CompletableFuture<?> completionFut) {
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(cancelAction, "cancelAction");
        Objects.requireNonNull(completionFut, "completionFut");
        CancelHandleImpl.CancellationTokenImpl t = CancelHandleHelper.unwrapToken(token);
        t.addCancelAction(cancelAction, completionFut);
    }

    public static void addCancelAction(CancellationToken token, CompletableFuture<?> completionFut) {
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(completionFut, "completionFut");
        CancelHandleHelper.addCancelAction(token, () -> completionFut.cancel(true), completionFut);
    }

    public static boolean isCancelled(CancellationToken token) {
        return CancelHandleHelper.unwrapToken(token).isCancelled();
    }

    private static CancelHandleImpl.CancellationTokenImpl unwrapToken(CancellationToken token) {
        if (token instanceof CancelHandleImpl.CancellationTokenImpl) {
            return (CancelHandleImpl.CancellationTokenImpl)token;
        }
        throw new IllegalArgumentException("Unexpected CancellationToken: " + token.getClass());
    }
}

