/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.Iterator;
import java.util.function.Function;

public class TransformingIterator<TinT, ToutT>
implements Iterator<ToutT>,
AutoCloseable {
    private final Iterator<TinT> delegate;
    private final Function<TinT, ToutT> transformation;

    public TransformingIterator(Iterator<TinT> delegate, Function<TinT, ToutT> transformation) {
        this.delegate = delegate;
        this.transformation = transformation;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public ToutT next() {
        return this.transformation.apply(this.delegate.next());
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void close() throws Exception {
        if (this.delegate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.delegate)).close();
        }
    }

    public static <TinT, ToutT> Iterable<ToutT> newIterable(Iterable<TinT> input, Function<TinT, ToutT> function) {
        return () -> new TransformingIterator(input.iterator(), function);
    }
}

