/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class FlatteningIterator<T>
implements Iterator<T>,
AutoCloseable {
    private final Iterator<? extends Iterable<T>> source;
    @Nullable
    private Iterator<T> current;

    public FlatteningIterator(Iterator<? extends Iterable<T>> source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.current != null) {
                if (this.current.hasNext()) {
                    return true;
                }
                this.current = null;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            this.current = this.source.next().iterator();
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.current != null);
        return this.current.next();
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.remove();
    }

    @Override
    public void close() throws Exception {
        if (this.source instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.source)).close();
        }
    }
}

