/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.type;

import java.util.EnumSet;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;
import org.gridgain.shaded.org.jetbrains.annotations.TestOnly;

public class NativeType
implements Comparable<NativeType> {
    private final ColumnType typeSpec;
    private final int size;
    private final boolean fixedSize;

    protected NativeType(ColumnType typeSpec, int size) {
        this(typeSpec, NativeType.isFixedSize(typeSpec), size);
    }

    protected NativeType(ColumnType typeSpec) {
        this(typeSpec, NativeType.isFixedSize(typeSpec), 0);
    }

    private static boolean isFixedSize(ColumnType typeSpec) {
        return (!typeSpec.precisionAllowed() || !typeSpec.scaleAllowed()) && !typeSpec.lengthAllowed();
    }

    protected NativeType(ColumnType typeSpec, boolean fixedSize, int size) {
        if (fixedSize && size <= 0) {
            throw new IllegalArgumentException("Size must be positive [typeSpec=" + typeSpec + ", size=" + size + "]");
        }
        if (!fixedSize && size > 0) {
            throw new IllegalArgumentException("Size must be provided only for fixed-length types: " + typeSpec);
        }
        this.fixedSize = fixedSize;
        this.typeSpec = typeSpec;
        this.size = size;
    }

    public boolean fixedLength() {
        return this.fixedSize;
    }

    public int sizeInBytes() {
        return this.size;
    }

    public ColumnType spec() {
        return this.typeSpec;
    }

    public boolean mismatch(NativeType type) {
        return this.typeSpec != type.typeSpec;
    }

    public String displayName() {
        return this.typeSpec.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeType that = (NativeType)o;
        return this.size == that.size && this.typeSpec == that.typeSpec;
    }

    public int hashCode() {
        int res = this.typeSpec.hashCode();
        res = 31 * res + this.size;
        return res;
    }

    @Override
    public int compareTo(NativeType o) {
        if (this.size <= 0 && o.size > 0) {
            return 1;
        }
        if (this.size > 0 && o.size <= 0) {
            return -1;
        }
        int cmp = Integer.compare(this.size, o.size);
        if (cmp != 0) {
            return cmp;
        }
        return this.typeSpec.name().compareTo(o.typeSpec.name());
    }

    public String toString() {
        return S.toString(NativeType.class.getSimpleName(), "name", (Object)this.typeSpec.name(), "sizeInBytes", (Object)this.size, "fixed", (Object)this.fixedLength());
    }

    @TestOnly
    public static ColumnType[] nativeTypes() {
        return (ColumnType[])EnumSet.complementOf(EnumSet.of(ColumnType.NULL, ColumnType.DURATION, ColumnType.PERIOD, ColumnType.STRUCT)).toArray(ColumnType[]::new);
    }
}

