/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.table.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.gridgain.shaded.org.apache.ignite.cache.Cache;
import org.gridgain.shaded.org.apache.ignite.cache.CacheStore;
import org.gridgain.shaded.org.apache.ignite.cache.CacheStoreFactory;
import org.gridgain.shaded.org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerItem;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerOptions;
import org.gridgain.shaded.org.apache.ignite.table.KeyValueView;
import org.gridgain.shaded.org.apache.ignite.table.Table;
import org.gridgain.shaded.org.apache.ignite.table.Tuple;
import org.gridgain.shaded.org.apache.ignite.table.mapper.Mapper;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public interface CacheLoader
extends Cache {
    public Table table();

    @Override
    default public <K, V> CompletableFuture<Void> loadAsync(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper, @Nullable BiPredicate<K, V> filter, Object ... args) {
        CacheStore<Object, Object> cacheStore = fac.create(keyMapper.targetType(), valMapper.targetType());
        KeyValueView<K, V> view = this.table().keyValueView(keyMapper, valMapper);
        SubmissionPublisher publisher = new SubmissionPublisher();
        CompletableFuture<Void> fut = view.streamData(publisher, DataStreamerOptions.DEFAULT);
        return ((CompletableFuture)cacheStore.loadCacheAsync((k, v) -> {
            if (filter == null || filter.test(k, v)) {
                publisher.submit(DataStreamerItem.of(Map.entry(k, v)));
            }
        }, args).handle((v, err) -> {
            publisher.close();
            if (err != null) {
                ExceptionUtils.sneakyThrow(err);
            }
            return fut;
        })).thenCompose(Function.identity());
    }

    @Override
    default public CompletableFuture<Void> loadAsync(CacheStoreFactory fac, @Nullable BiPredicate<Tuple, Tuple> filter, Object ... args) {
        CacheStore<Tuple, Tuple> cacheStore = fac.create(Tuple.class, Tuple.class);
        KeyValueView<Tuple, Tuple> view = this.table().keyValueView();
        SubmissionPublisher publisher = new SubmissionPublisher();
        CompletableFuture<Void> fut = view.streamData(publisher, DataStreamerOptions.DEFAULT);
        return ((CompletableFuture)cacheStore.loadCacheAsync((k, v) -> {
            if (filter != null && filter.test((Tuple)k, (Tuple)v)) {
                publisher.submit(DataStreamerItem.of(Map.entry(k, v)));
            }
        }, args).handle((v, err) -> {
            publisher.close();
            if (err != null) {
                ExceptionUtils.sneakyThrow(err);
            }
            return fut;
        })).thenCompose(Function.identity());
    }
}

