/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.lang;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteUuid;

public class IgniteUuidGenerator {
    private final UUID globalId;
    private final AtomicLong cntGen;

    public IgniteUuidGenerator(UUID globalId, long genStart) {
        this.globalId = globalId;
        this.cntGen = new AtomicLong(genStart);
    }

    public UUID vmId() {
        return this.globalId;
    }

    public long lastLocalId() {
        return this.cntGen.get();
    }

    public IgniteUuid randomUuid() {
        return new IgniteUuid(this.globalId, this.cntGen.incrementAndGet());
    }

    public IgniteUuid fromUuid(UUID id) {
        Objects.requireNonNull(id, "id must not be null");
        return new IgniteUuid(id, this.cntGen.getAndIncrement());
    }
}

