/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event;

import org.gridgain.shaded.io.netty.util.internal.StringUtil;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;

public abstract class Response
implements ClientMessage {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILED = 1;
    private int status;
    private String err;

    protected Response() {
        this.status = 0;
    }

    protected Response(int status, String err) {
        assert (status != 0);
        this.status = status;
        this.err = err;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packInt(this.status);
        if (StringUtil.isNullOrEmpty(this.err)) {
            packer.packNil();
        } else {
            packer.packString(this.err);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.status = unpacker.unpackInt();
        if (!unpacker.tryUnpackNil()) {
            this.err = unpacker.unpackString();
        }
    }

    public int status() {
        return this.status;
    }

    public void status(int status) {
        this.status = status;
    }

    public String err() {
        return this.err;
    }

    public void err(String err) {
        this.err = err;
    }

    public boolean success() {
        return this.status == 0;
    }

    public String toString() {
        return S.toString(Response.class, this);
    }
}

