/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.tx;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.gridgain.shaded.org.apache.ignite.cache.CacheStore;
import org.gridgain.shaded.org.apache.ignite.cache.CacheStoreSession;
import org.gridgain.shaded.org.apache.ignite.cache.CacheWriteMode;
import org.gridgain.shaded.org.apache.ignite.internal.client.ClientChannel;
import org.gridgain.shaded.org.apache.ignite.internal.client.PartitionMapping;
import org.gridgain.shaded.org.apache.ignite.internal.client.PayloadOutputChannel;
import org.gridgain.shaded.org.apache.ignite.internal.client.ReliableChannel;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.WriteBehindService;
import org.gridgain.shaded.org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.gridgain.shaded.org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteBiTuple;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.shaded.org.apache.ignite.internal.replicator.TablePartitionId;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.shaded.org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.gridgain.shaded.org.apache.ignite.lang.ErrorGroups;
import org.gridgain.shaded.org.apache.ignite.lang.IgniteException;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.apache.ignite.tx.TransactionException;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;
import org.gridgain.shaded.org.jetbrains.annotations.TestOnly;

public class ClientTransaction
implements Transaction {
    private static final int NO_COMMIT_PARTITION = -1;
    public static final UUID EMPTY = new UUID(0L, 0L);
    private static final int STATE_OPEN = 0;
    private static final int STATE_COMMITTED = 1;
    private static final int STATE_ROLLED_BACK = 2;
    @IgniteToStringExclude
    private final ClientChannel ch;
    private final long id;
    @IgniteToStringExclude
    private final AtomicReference<CompletableFuture<Void>> finishFut = new AtomicReference();
    private final AtomicInteger state = new AtomicInteger(0);
    private final boolean isReadOnly;
    private final UUID txId;
    private final int commitTableId;
    private final int commitPartition;
    private final UUID coordId;
    private final String nodeName;
    private final long timeout;
    @IgniteToStringExclude
    private final Map<TablePartitionId, CompletableFuture<IgniteBiTuple<String, Long>>> enlisted = new ConcurrentHashMap<TablePartitionId, CompletableFuture<IgniteBiTuple<String, Long>>>();
    @IgniteToStringExclude
    private final HybridTimestampTracker tracker;
    @IgniteToStringExclude
    private final ReentrantReadWriteLock enlistPartitionLock = new ReentrantReadWriteLock();
    private final boolean external;
    @IgniteToStringExclude
    Map<CacheStore, Map> enlistedStores = null;
    @IgniteToStringExclude
    CacheWriteMode enlistedCacheWriteMode;
    @IgniteToStringExclude
    WriteBehindService writeBehindService;

    public ClientTransaction(ClientChannel ch, long id, boolean isReadOnly, boolean external, UUID txId, @Nullable PartitionMapping cpm, UUID coordId, HybridTimestampTracker tracker, long timeout) {
        this.ch = ch;
        this.id = id;
        this.isReadOnly = isReadOnly && !external;
        this.external = external;
        this.txId = txId;
        this.nodeName = ch.protocolContext().clusterNode().name();
        this.tracker = tracker;
        this.timeout = timeout;
        if (cpm != null) {
            this.commitTableId = cpm.tableId();
            this.commitPartition = cpm.partition();
        } else {
            this.commitTableId = -1;
            this.commitPartition = -1;
        }
        this.coordId = coordId;
        assert (txId == null || coordId != null);
    }

    public long id() {
        return this.id;
    }

    public UUID txId() {
        return this.txId;
    }

    public int commitTableId() {
        return this.commitTableId;
    }

    public int commitPartition() {
        return this.commitPartition;
    }

    public boolean hasCommitPartition() {
        return this.commitPartition != -1;
    }

    public UUID coordinatorId() {
        return this.coordId;
    }

    public long timeout() {
        return this.timeout;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public ClientChannel channel() {
        return this.ch;
    }

    @Override
    public void commit() throws TransactionException {
        ViewUtils.sync(this.commitAsync());
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        CompletionStage fut;
        this.enlistPartitionLock.writeLock().lock();
        try {
            if (!this.finishFut.compareAndSet(null, new CompletableFuture())) {
                CompletableFuture<Void> completableFuture = this.finishFut.get();
                return completableFuture;
            }
        }
        finally {
            this.enlistPartitionLock.writeLock().unlock();
        }
        boolean enabled = this.ch.protocolContext().isFeatureSupported(ProtocolBitmaskFeature.TX_PIGGYBACK);
        CompletableFuture<Object> completableFuture = fut = enabled ? this.ch.inflights().finishFuture(this.txId()) : CompletableFutures.nullCompletedFuture();
        if (this.external) {
            Objects.requireNonNull(this.enlistedStores);
            CacheStoreSession ses = this.enlistedStores.keySet().iterator().next().beginSession();
            Objects.requireNonNull(ses);
            for (Map.Entry<CacheStore, Map> entry : this.enlistedStores.entrySet()) {
                CacheStore store = entry.getKey();
                Map value1 = entry.getValue();
                for (Map.Entry entry0 : value1.entrySet()) {
                    Optional value = (Optional)entry0.getValue();
                    if (value.isEmpty()) {
                        fut = fut.thenCompose(res -> store.deleteAsync(ses, entry0.getKey()));
                        continue;
                    }
                    fut = fut.thenCompose(res -> store.writeAsync(ses, new AbstractMap.SimpleEntry(entry0.getKey(), value.get())));
                }
            }
            fut = ((CompletableFuture)fut.handle((ignored, err) -> {
                if (err != null) {
                    return ses.finishAsync(false).exceptionally(err0 -> {
                        err.addSuppressed((Throwable)err0);
                        ExceptionUtils.sneakyThrow(err);
                        return null;
                    });
                }
                return ses.finishAsync(true);
            })).thenCompose(Function.identity());
            if (this.enlistedCacheWriteMode == CacheWriteMode.ASYNC) {
                fut = this.writeBehindService.enqueue((CompletableFuture<Void>)fut);
            }
        }
        CompletionStage mainFinishFut = ((CompletableFuture)fut.handle((ignored, e) -> {
            if (e != null) {
                this.ch.serviceAsync(45, w -> {
                    w.out().packLong(this.id);
                    if (!this.isReadOnly && enabled) {
                        this.packEnlisted(w);
                    }
                }, r -> null);
                return CompletableFuture.failedFuture(e);
            }
            return this.ch.serviceAsync(44, w -> {
                w.out().packLong(this.id);
                if (!this.isReadOnly && enabled) {
                    this.packEnlisted(w);
                }
            }, r -> null);
        })).thenCompose(Function.identity());
        ((CompletableFuture)mainFinishFut).handle((res, e) -> {
            this.setState(1);
            this.ch.inflights().erase(this.txId());
            this.finishFut.get().complete(null);
            return null;
        });
        return mainFinishFut;
    }

    private void packEnlisted(PayloadOutputChannel w) {
        int pos = w.out().reserveInt();
        int cnt = 0;
        for (Map.Entry<TablePartitionId, CompletableFuture<IgniteBiTuple<String, Long>>> entry : this.enlisted.entrySet()) {
            IgniteBiTuple info = entry.getValue().getNow(null);
            if (info == null) continue;
            w.out().packInt(entry.getKey().tableId());
            w.out().packInt(entry.getKey().partitionId());
            w.out().packString((String)info.get1());
            w.out().packLong((Long)info.get2());
            ++cnt;
        }
        w.out().setInt(pos, cnt);
        if (cnt > 0) {
            w.out().packLong(this.tracker.get().longValue());
            w.out().packBoolean(!this.ch.inflights().contains(this.txId));
        }
    }

    @Override
    public void rollback() throws TransactionException {
        ViewUtils.sync(this.rollbackAsync());
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        this.enlistPartitionLock.writeLock().lock();
        try {
            if (!this.finishFut.compareAndSet(null, new CompletableFuture())) {
                CompletableFuture<Void> completableFuture = this.finishFut.get();
                return completableFuture;
            }
        }
        finally {
            this.enlistPartitionLock.writeLock().unlock();
        }
        CompletableFuture<Void> mainFinishFut = this.ch.serviceAsync(45, w -> {
            w.out().packLong(this.id);
            if (!this.isReadOnly && w.clientChannel().protocolContext().isFeatureSupported(ProtocolBitmaskFeature.TX_DIRECT_MAPPING)) {
                this.packEnlisted(w);
            }
        }, r -> null);
        mainFinishFut.handle((res, e) -> {
            this.setState(2);
            this.ch.inflights().erase(this.txId());
            this.finishFut.get().complete(null);
            return null;
        });
        return mainFinishFut;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public static ClientTransaction get(Transaction tx) {
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        ClientTransaction clientTx = ((ClientLazyTransaction)tx).startedTx();
        int state = clientTx.state.get();
        if (state == 0) {
            return clientTx;
        }
        throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format("Transaction is already finished [tx={}].", clientTx));
    }

    static IgniteException unsupportedTxTypeException(Transaction tx) {
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unsupported transaction implementation: '" + tx.getClass() + "'. Use IgniteClient.transactions() to start transactions.");
    }

    private void setState(int state) {
        this.state.compareAndExchange(0, state);
    }

    private void checkEnlistPossible() {
        if (this.finishFut.get() != null) {
            throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format("Transaction is already finished [tx={}].", this));
        }
    }

    public CompletableFuture<IgniteBiTuple<String, Long>> enlistFuture(ReliableChannel ch, ClientChannel opChannel, PartitionMapping pm, boolean trackOperation) {
        if (!this.enlistPartitionLock.readLock().tryLock()) {
            throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format("Transaction is already finished [tx={}].", this));
        }
        this.checkEnlistPossible();
        boolean[] first = new boolean[]{false};
        TablePartitionId tablePartitionId = new TablePartitionId(pm.tableId(), pm.partition());
        CompletableFuture fut = this.enlisted.compute(tablePartitionId, (k, v) -> {
            if (v == null) {
                first[0] = true;
                return new CompletableFuture();
            }
            return v;
        });
        this.enlistPartitionLock.readLock().unlock();
        this.checkEnlistPossible();
        if (trackOperation) {
            ch.inflights().addInflight(this.txId);
        }
        if (first[0]) {
            return CompletableFuture.completedFuture(new IgniteBiTuple<Object, Object>(null, null));
        }
        return fut;
    }

    public void tryFinishEnlist(PartitionMapping pm, String consistentId, long token) {
        if (!this.hasCommitPartition()) {
            return;
        }
        TablePartitionId tablePartitionId = new TablePartitionId(pm.tableId(), pm.partition());
        CompletableFuture<IgniteBiTuple<String, Long>> fut = this.enlisted.get(tablePartitionId);
        if (fut != null && !fut.isDone()) {
            fut.complete(new IgniteBiTuple<String, Long>(consistentId, token));
        }
    }

    public void tryFailEnlist(PartitionMapping pm, Exception exception) {
        if (!this.hasCommitPartition()) {
            return;
        }
        TablePartitionId tablePartitionId = new TablePartitionId(pm.tableId(), pm.partition());
        CompletableFuture<IgniteBiTuple<String, Long>> fut = this.enlisted.get(tablePartitionId);
        if (fut != null && !fut.isDone()) {
            fut.completeExceptionally(exception);
        }
    }

    @TestOnly
    public int enlistedCount() {
        return this.enlisted.size();
    }

    public boolean isOpen() {
        int state0 = this.state.get();
        return state0 == 0;
    }

    public boolean external() {
        return this.external;
    }

    public void fail() {
        this.state.set(2);
        this.finishFut.set(CompletableFutures.nullCompletedFuture());
    }

    public String toString() {
        return S.toString(this);
    }
}

