/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.shaded.org.apache.ignite.internal.client.TcpIgniteClient;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientSchema;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientTable;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.gridgain.shaded.org.apache.ignite.internal.table.partition.HashPartition;
import org.gridgain.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.gridgain.shaded.org.apache.ignite.network.ClusterNode;
import org.gridgain.shaded.org.apache.ignite.table.Tuple;
import org.gridgain.shaded.org.apache.ignite.table.mapper.Mapper;
import org.gridgain.shaded.org.apache.ignite.table.partition.Partition;
import org.gridgain.shaded.org.apache.ignite.table.partition.PartitionManager;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class ClientPartitionManager
implements PartitionManager {
    private final ClientTable tbl;
    private final Lock lock = new ReentrantLock();
    private final Map<Partition, ClusterNode> cache = new HashMap<Partition, ClusterNode>();
    private long assignmentChangeTimestamp;

    ClientPartitionManager(ClientTable clientTable) {
        this.tbl = clientTable;
    }

    @Override
    public CompletableFuture<List<Partition>> partitionsAsync() {
        int partitionCount = this.tbl.tryGetPartitionCount();
        if (partitionCount != -1) {
            return CompletableFuture.completedFuture(ClientPartitionManager.getPartitions(partitionCount));
        }
        return this.tbl.getPartitionAssignment().thenApply(pa -> ClientPartitionManager.getPartitions(pa.size()));
    }

    @Override
    public List<Partition> partitions() {
        return ViewUtils.sync(this.partitionsAsync());
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        ClusterNode clusterNode = this.getClusterNode(partition);
        if (clusterNode != null) {
            return CompletableFuture.completedFuture(clusterNode);
        }
        return this.primaryReplicasAsync().thenApply(map -> (ClusterNode)map.get(partition));
    }

    @Override
    public ClusterNode primaryReplica(Partition partition) {
        return ViewUtils.sync(this.primaryReplicaAsync(partition));
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        Map<Partition, ClusterNode> cache = this.lookupCache();
        if (cache != null) {
            return CompletableFuture.completedFuture(cache);
        }
        long currentTs = this.tbl.channel().partitionAssignmentTimestamp();
        return this.tbl.channel().serviceAsync(65, w -> w.out().packInt(this.tbl.tableId()), r -> {
            ClientMessageUnpacker in = r.in();
            int size = in.unpackInt();
            HashMap<HashPartition, ClusterNode> res = new HashMap<HashPartition, ClusterNode>(size);
            for (int i = 0; i < size; ++i) {
                int partition = in.unpackInt();
                res.put(new HashPartition(partition), TcpIgniteClient.unpackClusterNode(r));
            }
            return res;
        }).thenApply(map -> this.updateCache((Map<Partition, ClusterNode>)map, currentTs));
    }

    @Override
    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.primaryReplicasAsync().thenApply(map -> {
            ArrayList<Partition> parts = new ArrayList<Partition>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (!((ClusterNode)entry.getValue()).equals(node)) continue;
                parts.add((Partition)entry.getKey());
            }
            return parts;
        });
    }

    @Override
    public Map<Partition, ClusterNode> primaryReplicas() {
        return ViewUtils.sync(this.primaryReplicasAsync());
    }

    @Override
    public List<Partition> primaryReplicas(ClusterNode node) {
        return ViewUtils.sync(this.primaryReplicasAsync(node));
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        Objects.requireNonNull(key, "Key is null.");
        Objects.requireNonNull(mapper, "Mapper is null.");
        return this.getPartition(ClientTupleSerializer.getPartitionAwarenessProvider(mapper, key));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        Objects.requireNonNull(key, "Key is null.");
        return this.getPartition(ClientTupleSerializer.getPartitionAwarenessProvider(key));
    }

    @Override
    public <K> Partition partition(K key, Mapper<K> mapper) {
        return ViewUtils.sync(this.partitionAsync(key, mapper));
    }

    @Override
    public Partition partition(Tuple key) {
        return ViewUtils.sync(this.partitionAsync(key));
    }

    @Nullable
    private ClusterNode getClusterNode(Partition partition) {
        this.lock.lock();
        try {
            if (this.tbl.channel().partitionAssignmentTimestamp() > this.assignmentChangeTimestamp) {
                this.cache.clear();
                ClusterNode clusterNode = null;
                return clusterNode;
            }
            ClusterNode clusterNode = this.cache.get(partition);
            return clusterNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    private Map<Partition, ClusterNode> lookupCache() {
        this.lock.lock();
        try {
            if (this.tbl.channel().partitionAssignmentTimestamp() > this.assignmentChangeTimestamp) {
                this.cache.clear();
                Map<Partition, ClusterNode> map = null;
                return map;
            }
            Map<Partition, ClusterNode> map = Map.copyOf(this.cache);
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Partition, ClusterNode> updateCache(Map<Partition, ClusterNode> map, long timestamp) {
        this.lock.lock();
        try {
            this.cache.putAll(map);
            this.assignmentChangeTimestamp = timestamp;
            Map<Partition, ClusterNode> map2 = map;
            return map2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private CompletableFuture<Partition> getPartition(PartitionAwarenessProvider partitionAwarenessProvider) {
        return this.tbl.getPartitionAssignment().thenCompose(partitions -> this.tbl.getLatestSchema().thenApply(schema -> {
            Integer hash = partitionAwarenessProvider.getObjectHashCode((ClientSchema)schema);
            assert (hash != null);
            return new HashPartition(Math.abs(hash % partitions.size()));
        }));
    }

    private static List<Partition> getPartitions(int partitionCount) {
        ArrayList<Partition> parts = new ArrayList<Partition>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            parts.add(new HashPartition(i));
        }
        return parts;
    }
}

