/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.proto;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ColumnTypeConverter;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.shaded.org.apache.ignite.internal.type.NativeType;
import org.gridgain.shaded.org.apache.ignite.internal.type.NativeTypes;
import org.gridgain.shaded.org.apache.ignite.lang.ErrorGroups;
import org.gridgain.shaded.org.apache.ignite.lang.IgniteException;
import org.gridgain.shaded.org.apache.ignite.lang.MarshallerException;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class ClientBinaryTupleUtils {
    @Nullable
    public static Object readObject(BinaryTupleReader reader, int index) {
        if (reader.hasNullValue(index)) {
            return null;
        }
        int typeId = reader.intValue(index);
        ColumnType type = ColumnTypeConverter.fromIdOrThrow(typeId);
        int valIdx = index + 2;
        switch (type) {
            case INT8: {
                return reader.byteValue(valIdx);
            }
            case INT16: {
                return reader.shortValue(valIdx);
            }
            case INT32: {
                return reader.intValue(valIdx);
            }
            case INT64: {
                return reader.longValue(valIdx);
            }
            case FLOAT: {
                return Float.valueOf(reader.floatValue(valIdx));
            }
            case DOUBLE: {
                return reader.doubleValue(valIdx);
            }
            case DECIMAL: {
                return reader.decimalValue(valIdx, reader.intValue(index + 1));
            }
            case UUID: {
                return reader.uuidValue(valIdx);
            }
            case STRING: {
                return reader.stringValue(valIdx);
            }
            case BYTE_ARRAY: {
                return reader.bytesValue(valIdx);
            }
            case DATE: {
                return reader.dateValue(valIdx);
            }
            case TIME: {
                return reader.timeValue(valIdx);
            }
            case DATETIME: {
                return reader.dateTimeValue(valIdx);
            }
            case TIMESTAMP: {
                return reader.timestampValue(valIdx);
            }
            case BOOLEAN: {
                return reader.byteValue(valIdx) != 0;
            }
            case DURATION: {
                return reader.durationValue(valIdx);
            }
            case PERIOD: {
                return reader.periodValue(valIdx);
            }
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(typeId);
    }

    public static <T> void appendObject(BinaryTupleBuilder builder, @Nullable T obj) {
        if (obj == null) {
            builder.appendNull();
            builder.appendNull();
            builder.appendNull();
        } else if (obj instanceof Boolean) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.BOOLEAN);
            builder.appendBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT8);
            builder.appendByte((Byte)obj);
        } else if (obj instanceof Short) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT16);
            builder.appendShort((Short)obj);
        } else if (obj instanceof Integer) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT32);
            builder.appendInt((Integer)obj);
        } else if (obj instanceof Long) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT64);
            builder.appendLong((Long)obj);
        } else if (obj instanceof Float) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.FLOAT);
            builder.appendFloat((Float)obj);
        } else if (obj instanceof Double) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DOUBLE);
            builder.appendDouble((Double)obj);
        } else if (obj instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)obj;
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DECIMAL, bigDecimal.scale());
            builder.appendDecimal(bigDecimal, bigDecimal.scale());
        } else if (obj instanceof UUID) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.UUID);
            builder.appendUuid((UUID)obj);
        } else if (obj instanceof String) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.STRING);
            builder.appendString((String)obj);
        } else if (obj instanceof byte[]) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.BYTE_ARRAY);
            builder.appendBytes((byte[])obj);
        } else if (obj instanceof LocalDate) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DATE);
            builder.appendDate((LocalDate)obj);
        } else if (obj instanceof LocalTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.TIME);
            builder.appendTime((LocalTime)obj);
        } else if (obj instanceof LocalDateTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DATETIME);
            builder.appendDateTime((LocalDateTime)obj);
        } else if (obj instanceof Instant) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.TIMESTAMP);
            builder.appendTimestamp((Instant)obj);
        } else if (obj instanceof Duration) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DURATION);
            builder.appendDuration((Duration)obj);
        } else if (obj instanceof Period) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.PERIOD);
            builder.appendPeriod((Period)obj);
        } else {
            throw ClientBinaryTupleUtils.unsupportedTypeException(obj.getClass());
        }
    }

    public static void appendValue(BinaryTupleBuilder builder, ColumnType type, String name, int scale, @Nullable Object v) {
        if (v == null) {
            builder.appendNull();
            return;
        }
        try {
            switch (type) {
                case BOOLEAN: {
                    builder.appendBoolean((boolean)((Boolean)v));
                    return;
                }
                case INT8: {
                    builder.appendByte((byte)((Byte)v));
                    return;
                }
                case INT16: {
                    builder.appendShort((short)((Short)v));
                    return;
                }
                case INT32: {
                    builder.appendInt((int)((Integer)v));
                    return;
                }
                case INT64: {
                    builder.appendLong((long)((Long)v));
                    return;
                }
                case FLOAT: {
                    builder.appendFloat(((Float)v).floatValue());
                    return;
                }
                case DOUBLE: {
                    builder.appendDouble((double)((Double)v));
                    return;
                }
                case DECIMAL: {
                    builder.appendDecimalNotNull((BigDecimal)v, scale);
                    return;
                }
                case UUID: {
                    builder.appendUuidNotNull((UUID)v);
                    return;
                }
                case STRING: {
                    builder.appendStringNotNull((String)v);
                    return;
                }
                case BYTE_ARRAY: {
                    builder.appendBytesNotNull((byte[])v);
                    return;
                }
                case DATE: {
                    builder.appendDateNotNull((LocalDate)v);
                    return;
                }
                case TIME: {
                    builder.appendTimeNotNull((LocalTime)v);
                    return;
                }
                case DATETIME: {
                    builder.appendDateTimeNotNull((LocalDateTime)v);
                    return;
                }
                case TIMESTAMP: {
                    builder.appendTimestampNotNull((Instant)v);
                    return;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        catch (ClassCastException e) {
            NativeType nativeType = NativeTypes.fromObject(v);
            if (nativeType == null) {
                throw new MarshallerException(String.format("Invalid value type provided for column [name='%s', expected='%s', actual='%s']", name, type.javaClass().getName(), v.getClass().getName()), (Throwable)e);
            }
            ColumnType actualType = nativeType.spec();
            String error = IgniteStringFormatter.format("Value type does not match [column='{}', expected={}, actual={}]", name, type.name(), actualType.name());
            throw new MarshallerException(error, (Throwable)e);
        }
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, ColumnType type, int scale) {
        builder.appendInt(type.id());
        builder.appendInt(scale);
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, ColumnType type) {
        builder.appendInt(type.id());
        builder.appendInt(0);
    }

    static IgniteException unsupportedTypeException(int dataType) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + dataType);
    }

    static IgniteException unsupportedTypeException(Class<?> cls) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + cls);
    }
}

