/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.model;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gridgain.ml.model.ModelConfig;
import org.gridgain.ml.model.ModelInfo;
import org.gridgain.ml.model.ModelType;
import org.gridgain.shaded.org.apache.ignite.compute.ComputeJob;
import org.gridgain.shaded.org.apache.ignite.marshalling.Marshaller;

public abstract class MlJobParameters
extends ModelInfo {
    private static final long serialVersionUID = 1L;
    private static final long DEFAULT_TIMEOUT_SECONDS = 300L;
    private OperationType operationType;
    private long timeoutSeconds;
    private transient Class customJobClass;
    private transient Marshaller<?, byte[]> customInputMarshaller;
    private transient Marshaller<?, byte[]> customOutputMarshaller;

    protected MlJobParameters(Builder builder) {
        super(builder);
        this.operationType = builder.operationType;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.customJobClass = builder.customJobClass;
        this.customInputMarshaller = builder.customInputMarshaller;
        this.customOutputMarshaller = builder.customOutputMarshaller;
    }

    public OperationType operationType() {
        return this.operationType;
    }

    public void operationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public long timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void timeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Class<? extends ComputeJob<?, ?>> customJobClass() {
        return this.customJobClass;
    }

    public void customJobClass(Class customJobClass) {
        this.customJobClass = customJobClass;
    }

    public <T> Marshaller<T, byte[]> customInputMarshaller() {
        return this.customInputMarshaller;
    }

    public void customInputMarshaller(Marshaller<?, byte[]> customInputMarshaller) {
        this.customInputMarshaller = customInputMarshaller;
    }

    public <T> Marshaller<T, byte[]> customOutputMarshaller() {
        return this.customOutputMarshaller;
    }

    public void customOutputMarshaller(Marshaller<?, byte[]> customOutputMarshaller) {
        this.customOutputMarshaller = customOutputMarshaller;
    }

    public boolean hasCustomComponents() {
        return this.customJobClass != null;
    }

    public boolean hasUrl() {
        return this.url() != null && !this.url().isEmpty();
    }

    public void validate() {
        if (this.id() == null || this.id().isEmpty()) {
            throw new IllegalStateException("Model ID & Version are required");
        }
        if (this.timeoutSeconds <= 0L) {
            throw new IllegalStateException("Timeout must be positive, got: " + this.timeoutSeconds);
        }
        if (this.customInputMarshaller != null && this.customOutputMarshaller == null) {
            throw new IllegalStateException("Custom output marshaller must be provided when custom input marshaller is specified");
        }
        if (this.customOutputMarshaller != null && this.customInputMarshaller == null) {
            throw new IllegalStateException("Custom input marshaller must be provided when custom output marshaller is specified");
        }
        this.validateOperationSpecific();
    }

    protected abstract void validateOperationSpecific();

    public String toString() {
        return "MlJobParameters{modelId='" + this.id() + "', modelName='" + this.name() + "', version='" + this.version() + "', type=" + this.type() + ", url='" + this.url() + "', operationType=" + this.operationType + ", timeoutSeconds=" + this.timeoutSeconds + ", hasCustomComponents=" + this.hasCustomComponents() + (String)(this.customJobClass != null ? ", customJobClass=" + this.customJobClass.getName() : "") + (String)(this.customInputMarshaller != null ? ", customInputMarshaller=" + this.customInputMarshaller.getClass().getName() : "") + (String)(this.customOutputMarshaller != null ? ", customOutputMarshaller=" + this.customOutputMarshaller.getClass().getName() : "") + "}";
    }

    public static abstract class Builder
    extends ModelInfo.Builder {
        protected OperationType operationType;
        protected long timeoutSeconds = 300L;
        protected Class<? extends ComputeJob<?, ?>> customJobClass;
        protected Marshaller<?, byte[]> customInputMarshaller;
        protected Marshaller<?, byte[]> customOutputMarshaller;

        @Override
        public Builder id(String id) {
            super.id(id);
            return this;
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder version(String version) {
            super.version(version);
            return this;
        }

        @Override
        public Builder type(ModelType type) {
            super.type(type);
            return this;
        }

        @Override
        public Builder url(String url) {
            super.url(url);
            return this;
        }

        @Override
        public Builder config(ModelConfig config) {
            super.config(config);
            return this;
        }

        @Override
        public Builder addProperty(String key, String value) {
            super.addProperty(key, value);
            return this;
        }

        @Override
        public Builder property(String key, String value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder properties(Map<String, String> properties) {
            super.properties(properties);
            return this;
        }

        @Override
        public Builder loaded(boolean loaded) {
            super.loaded(loaded);
            return this;
        }

        @Override
        public Builder loadTimestamp(long loadTimestamp) {
            super.loadTimestamp(loadTimestamp);
            return this;
        }

        @Override
        public Builder status(ModelInfo.ModelStatus status) {
            super.status(status);
            return this;
        }

        @Override
        public Builder inputClass(String inputClass) {
            super.inputClass(inputClass);
            return this;
        }

        @Override
        public Builder outputClass(String outputClass) {
            super.outputClass(outputClass);
            return this;
        }

        @Override
        public Builder translator(String translator) {
            super.translator(translator);
            return this;
        }

        @Override
        public Builder translatorFactory(String translatorFactory) {
            super.translatorFactory(translatorFactory);
            return this;
        }

        @Override
        public Builder from(ModelInfo modelInfo) {
            super.from(modelInfo);
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder timeoutSeconds(long timeoutSeconds) {
            if (timeoutSeconds <= 0L) {
                throw new IllegalArgumentException("Timeout must be positive, got: " + timeoutSeconds);
            }
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder timeout(long timeout, TimeUnit unit) {
            return this.timeoutSeconds(unit.toSeconds(timeout));
        }

        public Builder customJobClass(Class customJobClass) {
            this.customJobClass = customJobClass;
            return this;
        }

        public Builder customInputMarshaller(Marshaller<?, byte[]> customInputMarshaller) {
            this.customInputMarshaller = customInputMarshaller;
            return this;
        }

        public Builder customOutputMarshaller(Marshaller<?, byte[]> customOutputMarshaller) {
            this.customOutputMarshaller = customOutputMarshaller;
            return this;
        }

        @Override
        public abstract MlJobParameters build();
    }

    public static enum OperationType {
        PREDICT,
        BATCH_PREDICT,
        SQL_PREDICT,
        COLOCATED_PREDICT;

    }
}

