/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.password;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.gridgain.internal.rbac.password.BlowfishPasswordFormatValidator;
import org.gridgain.internal.rbac.password.PasswordEncoder;

class BlowfishPasswordEncoder
implements PasswordEncoder {
    private static final Random RANDOM_INSTANCE = new SecureRandom();
    private static final int BCRYPT_SALT_LENGTH = 16;
    private static final String BCRYPT_VERSION = "2y";
    private static final int PASSWORD_ENCODING_COST = 12;
    private final Executor executor;

    BlowfishPasswordEncoder(Executor executor) {
        this.executor = executor;
    }

    @Override
    public CompletableFuture<String> encodeAsync(String password) {
        return CompletableFuture.supplyAsync(() -> OpenBSDBCrypt.generate(BCRYPT_VERSION, password.toCharArray(), BlowfishPasswordEncoder.generateSalt(), 12), this.executor);
    }

    @Override
    public CompletableFuture<Boolean> matchAsync(String rawPassword, String encodedPassword) {
        return CompletableFuture.supplyAsync(() -> OpenBSDBCrypt.checkPassword(encodedPassword, rawPassword.toCharArray()), this.executor);
    }

    @Override
    public boolean isValidFormat(String encodedPassword) {
        try {
            return BlowfishPasswordFormatValidator.isValidFormat(encodedPassword);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[16];
        RANDOM_INSTANCE.nextBytes(salt);
        return salt;
    }
}

