/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.lang;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;

public final class IgniteUuid
implements Comparable<IgniteUuid>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID gid;
    private final long locId;

    public static Comparator<IgniteUuid> globalOrderComparator() {
        return (uuid1, uuid2) -> {
            if (uuid1 == uuid2) {
                return 0;
            }
            int res = uuid1.globalId().compareTo(uuid2.globalId());
            if (res == 0) {
                res = Long.compare(uuid1.localId(), uuid2.localId());
            }
            return res;
        };
    }

    public static Comparator<IgniteUuid> naturalOrderComparator() {
        return IgniteUuid::compareTo;
    }

    public IgniteUuid(UUID gid, long locId) {
        assert (gid != null);
        this.gid = gid;
        this.locId = locId;
    }

    public static IgniteUuid fromString(String s) {
        int firstDash = s.indexOf(45);
        return new IgniteUuid(UUID.fromString(s.substring(firstDash + 1)), Long.valueOf(new StringBuilder(s.substring(0, firstDash)).reverse().toString(), 16));
    }

    public String shortString() {
        return new StringBuilder(Long.toHexString(this.locId)).reverse().toString();
    }

    public UUID globalId() {
        return this.gid;
    }

    public long localId() {
        return this.locId;
    }

    @Override
    public int compareTo(IgniteUuid o) {
        if (o == this) {
            return 0;
        }
        int res = Long.compare(this.locId, o.locId);
        if (res == 0) {
            res = this.gid.compareTo(o.globalId());
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IgniteUuid)) {
            return false;
        }
        IgniteUuid that = (IgniteUuid)obj;
        return that.locId == this.locId && that.gid.equals(this.gid);
    }

    public int hashCode() {
        return 31 * this.gid.hashCode() + (int)(this.locId ^ this.locId >>> 32);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.shortString() + "-" + this.gid.toString();
    }
}

