/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.Response;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.internal.util.ArrayUtils;

public class JdbcBatchExecuteResult
extends Response {
    private int[] updateCnts;
    private int errorCode;

    public JdbcBatchExecuteResult() {
    }

    public JdbcBatchExecuteResult(int status, int errorCode, String errorMessage, int[] updateCnts) {
        super(status, errorMessage);
        this.errorCode = errorCode;
        this.updateCnts = updateCnts;
    }

    public JdbcBatchExecuteResult(int status, String err) {
        super(status, err);
    }

    public JdbcBatchExecuteResult(int[] updateCnts) {
        Objects.requireNonNull(updateCnts);
        this.updateCnts = updateCnts;
    }

    public int[] updateCounts() {
        return this.updateCnts == null ? ArrayUtils.INT_EMPTY_ARRAY : this.updateCnts;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        packer.packInt(this.errorCode);
        packer.packIntArray(this.updateCnts);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        this.errorCode = unpacker.unpackInt();
        this.updateCnts = unpacker.tryUnpackNil() ? ArrayUtils.INT_EMPTY_ARRAY : unpacker.unpackIntArray();
    }

    @Override
    public String toString() {
        return S.toString(JdbcBatchExecuteResult.class, this);
    }
}

