/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.continuousquery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.internal.continuousquery.ContinuousQueryEventWatermark;
import org.gridgain.shaded.org.apache.ignite.internal.continuousquery.RowUpdateInfo;
import org.gridgain.shaded.org.apache.ignite.table.ContinuousQueryWatermark;
import org.gridgain.shaded.org.apache.ignite.table.TableRowEvent;
import org.gridgain.shaded.org.apache.ignite.table.TableRowEventBatch;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class TableRowEventBatchImpl<T>
implements TableRowEventBatch<T>,
AutoCloseable,
List<TableRowEvent<T>> {
    private final List<TableRowEvent<T>> rows;
    private final List<? extends RowUpdateInfo<?>> rowUpdateInfos;
    private final UUID[] cqStateRowIds;
    private final long[] cqStateTimestamps;
    private final int partId;
    @Nullable
    private final Integer schemaVersion;
    private volatile boolean isCqStateAccessible = true;

    TableRowEventBatchImpl(List<TableRowEvent<T>> rows, List<? extends RowUpdateInfo<?>> rowUpdateInfos, UUID[] cqStateRowIds, long[] cqStateTimestamps, int partId, @Nullable Integer schemaVersion) {
        this.rows = rows;
        this.rowUpdateInfos = rowUpdateInfos;
        this.cqStateRowIds = cqStateRowIds;
        this.cqStateTimestamps = cqStateTimestamps;
        this.partId = partId;
        this.schemaVersion = schemaVersion;
    }

    @Override
    public List<TableRowEvent<T>> rows() {
        this.checkRowsAccessible();
        return this;
    }

    @Override
    public ContinuousQueryWatermark watermark() {
        return this.watermark(this.rows.size() - 1);
    }

    ContinuousQueryWatermark watermark(int rowBatchIndex) {
        this.checkAccessible("watermark");
        UUID[] rowIds = (UUID[])this.cqStateRowIds.clone();
        long[] timestamps = (long[])this.cqStateTimestamps.clone();
        if (rowBatchIndex >= 0) {
            RowUpdateInfo<?> rowUpdateInfo = this.rowUpdateInfos.get(rowBatchIndex);
            rowIds[this.partId] = rowUpdateInfo.rowUuid();
            timestamps[this.partId] = rowUpdateInfo.timestamp().longValue();
        }
        return new ContinuousQueryEventWatermark(rowIds, timestamps);
    }

    byte[] watermarkBytes(int rowBatchIndex) {
        this.checkAccessible("watermark");
        byte[] bufArr = new byte[this.cqStateRowIds.length * 24];
        ByteBuffer buf = ByteBuffer.wrap(bufArr).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.cqStateRowIds.length; ++i) {
            long ts;
            UUID rowId;
            if (i == this.partId) {
                RowUpdateInfo<?> rowUpdateInfo = this.rowUpdateInfos.get(rowBatchIndex);
                rowId = rowUpdateInfo.rowUuid();
                ts = rowUpdateInfo.timestamp().longValue();
            } else {
                rowId = this.cqStateRowIds[i];
                ts = this.cqStateTimestamps[i];
            }
            buf.putLong(rowId.getMostSignificantBits());
            buf.putLong(rowId.getLeastSignificantBits());
            buf.putLong(ts);
        }
        return bufArr;
    }

    @Nullable
    public Integer schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public void close() throws Exception {
        this.isCqStateAccessible = false;
    }

    @Override
    public int size() {
        return this.rowsInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.rowsInternal().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.rowsInternal().contains(o);
    }

    @Override
    public Iterator<TableRowEvent<T>> iterator() {
        return this.rowsInternal().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.rowsInternal().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.rowsInternal().toArray(a);
    }

    @Override
    public boolean add(TableRowEvent<T> e) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public void add(int index, TableRowEvent<T> element) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public boolean remove(Object o) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public TableRowEvent<T> remove(int index) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rowsInternal().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TableRowEvent<T>> c) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends TableRowEvent<T>> c) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public void clear() {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public TableRowEvent<T> get(int index) {
        return this.rowsInternal().get(index);
    }

    @Override
    public TableRowEvent<T> set(int index, TableRowEvent<T> element) {
        throw TableRowEventBatchImpl.readOnlyException();
    }

    @Override
    public int indexOf(Object o) {
        return this.rowsInternal().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rowsInternal().lastIndexOf(o);
    }

    @Override
    public ListIterator<TableRowEvent<T>> listIterator() {
        return this.rowsInternal().listIterator();
    }

    @Override
    public ListIterator<TableRowEvent<T>> listIterator(int index) {
        return this.rowsInternal().listIterator(index);
    }

    @Override
    public List<TableRowEvent<T>> subList(int fromIndex, int toIndex) {
        return this.rowsInternal().subList(fromIndex, toIndex);
    }

    private List<TableRowEvent<T>> rowsInternal() {
        this.checkRowsAccessible();
        return this.rows;
    }

    private void checkRowsAccessible() {
        this.checkAccessible("rows");
    }

    private void checkAccessible(String thing) {
        if (!this.isCqStateAccessible) {
            throw new IllegalStateException(thing + " can not be accessed outside of Subscriber#onNext for performance reasons.");
        }
    }

    private static UnsupportedOperationException readOnlyException() {
        return new UnsupportedOperationException("Event batch is read-only.");
    }
}

