/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.table;

import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;

public class ClientColumn {
    private final String name;
    private final ColumnType type;
    private final boolean nullable;
    private final int keyIndex;
    private final int valIndex;
    private final int colocationIndex;
    private final int schemaIndex;
    private final int scale;
    private final int precision;

    public ClientColumn(String name, ColumnType type, boolean nullable, int keyIndex, int valIndex, int colocationIndex, int schemaIndex) {
        this(name, type, nullable, keyIndex, valIndex, colocationIndex, schemaIndex, 0, 0);
    }

    public ClientColumn(String name, ColumnType type, boolean nullable, int keyIndex, int valIndex, int colocationIndex, int schemaIndex, int scale, int precision) {
        assert (name != null);
        assert (schemaIndex >= 0);
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.keyIndex = keyIndex;
        this.valIndex = valIndex;
        this.colocationIndex = colocationIndex;
        this.schemaIndex = schemaIndex;
        this.scale = scale;
        this.precision = precision;
        assert (keyIndex < 0 || valIndex < 0) : "Column cannot be part of both key and value: " + name + " (keyIndex=" + keyIndex + ", valIndex=" + valIndex + ")";
    }

    public String name() {
        return this.name;
    }

    public ColumnType type() {
        return this.type;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean key() {
        return this.keyIndex >= 0;
    }

    public int colocationIndex() {
        return this.colocationIndex;
    }

    public int keyIndex() {
        return this.keyIndex;
    }

    public int valIndex() {
        return this.valIndex;
    }

    public int schemaIndex() {
        return this.schemaIndex;
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        return this.precision;
    }
}

