/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.io.netty.handler.ssl;

import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.gridgain.shaded.io.netty.buffer.ByteBufAllocator;
import org.gridgain.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.gridgain.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import org.gridgain.shaded.io.netty.handler.ssl.ClientAuth;
import org.gridgain.shaded.io.netty.handler.ssl.OpenSsl;
import org.gridgain.shaded.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import org.gridgain.shaded.io.netty.handler.ssl.OpenSslEngine;
import org.gridgain.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.gridgain.shaded.io.netty.handler.ssl.ResumptionController;
import org.gridgain.shaded.io.netty.handler.ssl.SslContextOption;

public abstract class OpenSslContext
extends ReferenceCountedOpenSslContext {
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, String endpointIdentificationAlgorithm, boolean enableOcsp, List<SNIServerName> serverNames, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, OpenSslContext.toNegotiator(apnCfg), mode, keyCertChain, clientAuth, protocols, startTls, endpointIdentificationAlgorithm, enableOcsp, false, serverNames, resumptionController, options);
    }

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, List<SNIServerName> serverNames, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, apn, mode, keyCertChain, clientAuth, protocols, startTls, null, enableOcsp, false, serverNames, resumptionController, options);
    }

    @Override
    final SSLEngine newEngine0(ByteBufAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort, jdkCompatibilityMode, this.endpointIdentificationAlgorithm, this.serverNames);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        OpenSsl.releaseIfNeeded(this);
    }
}

