/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.roles;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.rbac.privileges.ObjectTree;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.roles.exception.RoleValidationException;
import org.gridgain.shaded.org.apache.ignite.internal.util.StringUtils;

public class Role {
    private final String name;
    private final Set<Privilege> privileges;

    private Role(String name, Set<Privilege> privileges) {
        this.name = name;
        this.privileges = privileges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(Role role) {
        return Role.builder().name(role.name()).addPrivileges(role.privileges);
    }

    public String name() {
        return this.name;
    }

    public Set<Privilege> privileges() {
        return this.privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.name, role.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Role{name='" + this.name + "'}";
    }

    public static class Builder {
        private String name;
        private final Set<Privilege> privileges = new HashSet<Privilege>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addPrivileges(Set<Privilege> privileges) {
            this.privileges.addAll(privileges);
            return this;
        }

        public Builder removePrivileges(Set<Privilege> privileges) {
            this.privileges.removeIf(privilege -> {
                if (privileges.contains(privilege)) {
                    return true;
                }
                Set<Privilege> parents = ObjectTree.findParents(privilege);
                return privileges.stream().filter(privilegeToRemove -> privilegeToRemove.action() == privilege.action()).anyMatch(parents::contains);
            });
            return this;
        }

        public Role build() {
            if (StringUtils.nullOrBlank(this.name)) {
                throw new RoleValidationException("Role name cannot be null or empty");
            }
            return new Role(this.name, this.privileges);
        }
    }
}

