/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.authorization;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.shaded.org.apache.ignite.internal.util.ExceptionUtils;

public interface Authorizer {
    default public CompletableFuture<Void> authorizeAsync(Action action) {
        return this.authorizeAsync(Privilege.fromAction(action));
    }

    public CompletableFuture<Void> authorizeAsync(SecurityContext var1, Privilege var2);

    public CompletableFuture<Void> authorizeAsync(Privilege var1);

    public CompletableFuture<Void> authorizeAsync(SecurityContext var1, Set<Privilege> var2);

    public CompletableFuture<Void> authorizeAsync(Set<Privilege> var1);

    public void enable(boolean var1);

    default public <T> CompletableFuture<T> authorizeThenCompose(Privilege privilege, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.authorizeAsync(privilege).thenCompose(ign -> (CompletionStage)futureSupplier.get());
    }

    default public <T> CompletableFuture<T> authorizeThenCompose(SecurityContext context, Privilege privilege, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.authorizeAsync(context, privilege).thenCompose(ign -> (CompletionStage)futureSupplier.get());
    }

    default public <T> CompletableFuture<T> authorizeThenCompose(Action action, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.authorizeAsync(action).thenCompose(ign -> (CompletionStage)futureSupplier.get());
    }

    default public <T> CompletableFuture<T> authorizeThenCompose(Set<Privilege> privileges, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.authorizeAsync(privileges).thenCompose(ign -> (CompletionStage)futureSupplier.get());
    }

    default public <T> CompletableFuture<T> authorizeThenCompose(SecurityContext context, Set<Privilege> privileges, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.authorizeAsync(context, privileges).thenCompose(ign -> (CompletionStage)futureSupplier.get());
    }

    default public <T> T authorize(Action action, Supplier<T> supplier) {
        try {
            this.authorizeAsync(action).join();
            return supplier.get();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    default public void authorize(Action action, Runnable runnable) {
        try {
            this.authorizeAsync(action).join();
            runnable.run();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }
}

