/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ignite.internal.jdbc.ConnectionProperties;
import org.apache.ignite.internal.jdbc.ConnectionPropertiesImpl;
import org.apache.ignite.internal.jdbc.JdbcClientDatabaseMetadataHandler;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.gridgain.shaded.com.google.auto.service.AutoService;
import org.gridgain.shaded.org.apache.ignite.client.BasicAuthenticator;
import org.gridgain.shaded.org.apache.ignite.client.IgniteClientAuthenticator;
import org.gridgain.shaded.org.apache.ignite.client.IgniteClientConnectionException;
import org.gridgain.shaded.org.apache.ignite.client.RetryReadPolicy;
import org.gridgain.shaded.org.apache.ignite.client.SslConfiguration;
import org.gridgain.shaded.org.apache.ignite.internal.client.ChannelValidator;
import org.gridgain.shaded.org.apache.ignite.internal.client.HostAndPort;
import org.gridgain.shaded.org.apache.ignite.internal.client.IgniteClientConfigurationImpl;
import org.gridgain.shaded.org.apache.ignite.internal.client.TcpIgniteClient;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.gridgain.shaded.org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.shaded.org.apache.ignite.internal.properties.IgniteProductVersion;
import org.gridgain.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.gridgain.shaded.org.apache.ignite.lang.ErrorGroups;
import org.gridgain.shaded.org.apache.ignite.network.ClusterNode;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

@AutoService(value={Driver.class})
public class IgniteJdbcDriver
implements Driver {
    private static Driver instance;
    private static final int MAJOR_VER;
    private static final int MINOR_VER;
    private static final String FULL_VER;
    private final HybridTimestampTracker observableTimeTracker = HybridTimestampTracker.atomicTracker(null);

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        TcpIgniteClient client;
        if (!this.acceptsURL(url)) {
            return null;
        }
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, props);
        try {
            client = this.createIgniteClient(connProps, this.observableTimeTracker);
        }
        catch (Exception e) {
            throw new SQLException("Failed to connect to server", "08001", e);
        }
        JdbcClientDatabaseMetadataHandler eventHandler = new JdbcClientDatabaseMetadataHandler(client);
        return new JdbcConnection(client, eventHandler, connProps);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:ignite:thin://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, info);
        return connProps.getDriverPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return MAJOR_VER;
    }

    @Override
    public int getMinorVersion() {
        return MINOR_VER;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used.");
    }

    private static synchronized void register() {
        if (IgniteJdbcDriver.isRegistered()) {
            throw new RuntimeException("Driver is already registered. It can only be registered once.");
        }
        try {
            IgniteJdbcDriver registeredDriver = new IgniteJdbcDriver();
            DriverManager.registerDriver(registeredDriver);
            instance = registeredDriver;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Ignite JDBC driver.", e);
        }
    }

    private static boolean isRegistered() {
        return instance != null;
    }

    private TcpIgniteClient createIgniteClient(ConnectionProperties connectionProperties, HybridTimestampTracker observableTimeTracker) {
        String[] addresses = (String[])Arrays.stream(connectionProperties.getAddresses()).map(HostAndPort::toString).toArray(String[]::new);
        int networkTimeout = connectionProperties.getConnectionTimeout();
        IgniteClientConfigurationImpl cfg = new IgniteClientConfigurationImpl(null, addresses, networkTimeout, connectionProperties.getBackgroundReconnectInterval(), null, 30000L, 5000L, new RetryReadPolicy(), null, IgniteJdbcDriver.extractSslConfiguration(connectionProperties), false, IgniteJdbcDriver.extractAuthenticationConfiguration(connectionProperties), 0L, null, connectionProperties.getPartitionAwarenessMetadataCacheSize(), "Apache Ignite JDBC Driver", 30000L);
        ChannelValidator channelValidator = ctx -> {
            if (!ctx.isFeatureSupported(ProtocolBitmaskFeature.SQL_MULTISTATEMENT_SUPPORT)) {
                ClusterNode node = ctx.clusterNode();
                throw new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, IgniteStringFormatter.format("Connection to node aborted, because the node does not support the feature required by the driver being used. Please refer to the documentation and use a compatible version of the JDBC driver to connect to this node [nodeName={}, nodeAddress={}, nodeVersion={}, driverVersion={}]", node.name(), node.address(), ctx.productVersion(), FULL_VER), null);
            }
        };
        return (TcpIgniteClient)ViewUtils.sync(TcpIgniteClient.startAsync(cfg, observableTimeTracker, channelValidator));
    }

    @Nullable
    private static SslConfiguration extractSslConfiguration(ConnectionProperties connProps) {
        if (connProps.isSslEnabled()) {
            return SslConfiguration.builder().enabled(true).trustStorePath(connProps.getTrustStorePath()).trustStorePassword(connProps.getTrustStorePassword()).ciphers(connProps.getCiphers()).keyStorePath(connProps.getKeyStorePath()).keyStorePassword(connProps.getKeyStorePassword()).build();
        }
        return null;
    }

    @Nullable
    private static IgniteClientAuthenticator extractAuthenticationConfiguration(ConnectionProperties connProps) {
        String username = connProps.getUsername();
        String password = connProps.getPassword();
        if (username != null && password != null) {
            return BasicAuthenticator.builder().username(username).password(password).build();
        }
        return null;
    }

    static {
        IgniteJdbcDriver.register();
        MAJOR_VER = ProtocolVersion.LATEST_VER.major();
        MINOR_VER = ProtocolVersion.LATEST_VER.minor();
        FULL_VER = IgniteProductVersion.CURRENT_VERSION.toString();
    }
}

