/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.jdbc.ConnectionProperties;
import org.apache.ignite.internal.jdbc.JdbcDatabaseMetadata;
import org.apache.ignite.internal.jdbc.JdbcExceptionMapperUtil;
import org.apache.ignite.internal.jdbc.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.gridgain.shaded.org.apache.ignite.client.IgniteClient;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.JdbcDatabaseMetadataHandler;
import org.gridgain.shaded.org.apache.ignite.internal.sql.SqlCommon;
import org.gridgain.shaded.org.apache.ignite.sql.IgniteSql;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.apache.ignite.tx.TransactionOptions;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;
import org.gridgain.shaded.org.jetbrains.annotations.TestOnly;

public class JdbcConnection
implements Connection {
    private static final String CONNECTION_IS_CLOSED = "Connection is closed.";
    static final String RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED = "Returning auto-generated keys is not supported.";
    private static final String CALLABLE_FUNCTIONS_ARE_NOT_SUPPORTED = "Callable functions are not supported.";
    private static final String SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED = "SQL-specific types are not supported.";
    private static final String INVALID_RESULT_SET_HOLDABILITY = "Invalid result set holdability (only close cursors at commit option is supported).";
    private static final String INVALID_RESULT_SET_TYPE = "Invalid result set type (only forward is supported).";
    private static final String INVALID_RESULT_SET_CONCURRENCY = "Invalid concurrency (updates are not supported).";
    private static final String TRANSACTION_CANNOT_BE_COMMITED_IN_AUTOCOMMIT_MODE = "Transaction cannot be committed explicitly in auto-commit mode.";
    private static final String COMMIT_REQUEST_FAILED = "The transaction commit request failed.";
    private static final String TRANSACTION_CANNOT_BE_ROLLED_BACK_IN_AUTOCOMMIT_MODE = "Transaction cannot be rolled back explicitly in auto-commit mode.";
    private static final String ROLLBACK_REQUEST_FAILED = "The transaction rollback request failed.";
    private static final String CANNOT_SET_TRANSACTION_NONE = "Cannot set transaction isolation level to TRANSACTION_NONE.";
    private static final String INVALID_TRANSACTION_ISOLATION_LEVEL = "Invalid transaction isolation level.";
    private static final String SHARDING_KEYS_ARE_NOT_SUPPORTED = "Sharding keys are not supported.";
    private static final String SAVEPOINT_IN_AUTO_COMMIT_MODE = "Savepoint cannot be set in auto-commit mode.";
    private static final String SAVEPOINTS_ARE_NOT_SUPPORTED = "Savepoints are not supported.";
    private static final String TYPES_MAPPING_IS_NOT_SUPPORTED = "Types mapping is not supported.";
    private final IgniteClient igniteClient;
    private final IgniteSql igniteSql;
    private final ReentrantLock lock = new ReentrantLock();
    private final List<Statement> statements = new ArrayList<Statement>();
    private final ConnectionProperties properties;
    private final JdbcDatabaseMetadata metadata;
    private final int queryTimeoutSeconds;
    private volatile boolean closed;
    private String schemaName;
    private int txIsolation;
    private boolean autoCommit;
    private boolean readOnly;
    private int networkTimeoutMillis;
    @Nullable
    private Transaction transaction;

    public JdbcConnection(IgniteClient client, JdbcDatabaseMetadataHandler eventHandler, ConnectionProperties props) {
        this.igniteClient = client;
        this.igniteSql = client.sql();
        this.autoCommit = true;
        this.networkTimeoutMillis = props.getConnectionTimeout();
        this.queryTimeoutSeconds = props.getQueryTimeout();
        this.txIsolation = 8;
        this.schemaName = JdbcConnection.readSchemaName(props.getSchema());
        this.properties = props;
        this.metadata = new JdbcDatabaseMetadata(this, eventHandler, props.getUrl(), props.getUsername(), props::getConnectionTimeZone);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        JdbcConnection.checkCursorOptions(resSetType, resSetConcurrency, resSetHoldability);
        JdbcStatement statement = new JdbcStatement(this, this.igniteSql, this.schemaName, resSetHoldability, this.queryTimeoutSeconds);
        this.lock.lock();
        try {
            this.statements.add(statement);
        }
        finally {
            this.lock.unlock();
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        JdbcConnection.checkCursorOptions(resSetType, resSetConcurrency, resSetHoldability);
        return new JdbcPreparedStatement(this, this.igniteSql, this.schemaName, resSetHoldability, sql, this.queryTimeoutSeconds);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(RETURNING_AUTO_GENERATED_KEYS_IS_NOT_SUPPORTED);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(sql);
        return sql;
    }

    @Nullable
    Transaction startTransactionIfNoAutoCommit() {
        if (this.transaction == null && !this.autoCommit) {
            this.transaction = this.igniteClient.transactions().begin(new TransactionOptions().readOnly(false));
            return this.transaction;
        }
        return this.transaction;
    }

    private void commitTx() throws SQLException {
        Transaction tx = this.transaction;
        if (tx == null) {
            return;
        }
        this.transaction = null;
        try {
            tx.commit();
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(COMMIT_REQUEST_FAILED, e);
        }
    }

    private void rollbackTx() throws SQLException {
        Transaction tx = this.transaction;
        if (tx == null) {
            return;
        }
        this.transaction = null;
        try {
            tx.rollback();
        }
        catch (Exception e) {
            throw JdbcExceptionMapperUtil.mapToJdbcException(ROLLBACK_REQUEST_FAILED, e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        boolean wasAutoCommit = this.autoCommit;
        this.autoCommit = autoCommit;
        if (!wasAutoCommit && this.transaction != null) {
            this.commitTx();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException(TRANSACTION_CANNOT_BE_COMMITED_IN_AUTOCOMMIT_MODE);
        }
        this.commitTx();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException(TRANSACTION_CANNOT_BE_ROLLED_BACK_IN_AUTOCOMMIT_MODE);
        }
        this.rollbackTx();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Invalid savepoint.");
        }
        if (this.autoCommit) {
            throw new SQLException(TRANSACTION_CANNOT_BE_COMMITED_IN_AUTOCOMMIT_MODE);
        }
        throw new SQLFeatureNotSupportedException(SAVEPOINTS_ARE_NOT_SUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        ArrayList<Exception> suppressedExceptions = null;
        boolean wasAutoCommit = this.autoCommit;
        if (!wasAutoCommit && this.transaction != null) {
            this.rollbackTx();
        }
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (Statement statement : this.statements) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    if (suppressedExceptions == null) {
                        suppressedExceptions = new ArrayList<Exception>();
                    }
                    suppressedExceptions.add(e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.igniteClient.close();
        }
        catch (Exception e) {
            throw JdbcConnection.connectionCloseException(e, suppressedExceptions);
        }
        if (suppressedExceptions != null) {
            throw JdbcConnection.connectionCloseException(null, suppressedExceptions);
        }
    }

    private static SQLException connectionCloseException(@Nullable Exception e, @Nullable List<Exception> suppressedExceptions) {
        SQLException err = new SQLException("Exception occurred while closing a connection.", e);
        if (suppressedExceptions != null) {
            for (Exception suppressed : suppressedExceptions) {
                err.addSuppressed(suppressed);
            }
        }
        return err;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException(CONNECTION_IS_CLOSED, "08003");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return "IGNITE";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 0: {
                throw new SQLException(CANNOT_SET_TRANSACTION_NONE);
            }
            default: {
                throw new SQLException(INVALID_TRANSACTION_ISOLATION_LEVEL, "0700E");
            }
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        return this.txIsolation;
    }

    @Override
    @Nullable
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(TYPES_MAPPING_IS_NOT_SUPPORTED);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(TYPES_MAPPING_IS_NOT_SUPPORTED);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 2) {
            throw new SQLException(INVALID_RESULT_SET_HOLDABILITY);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException(SAVEPOINT_IN_AUTO_COMMIT_MODE);
        }
        throw new SQLFeatureNotSupportedException(SAVEPOINTS_ARE_NOT_SUPPORTED);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        if (name == null) {
            throw new SQLException("Savepoint name cannot be null.");
        }
        if (this.autoCommit) {
            throw new SQLException(SAVEPOINT_IN_AUTO_COMMIT_MODE);
        }
        throw new SQLFeatureNotSupportedException(SAVEPOINTS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Savepoint cannot be null.");
        }
        throw new SQLFeatureNotSupportedException(SAVEPOINTS_ARE_NOT_SUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CALLABLE_FUNCTIONS_ARE_NOT_SUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CALLABLE_FUNCTIONS_ARE_NOT_SUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(CALLABLE_FUNCTIONS_ARE_NOT_SUPPORTED);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        return !this.closed;
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException(CONNECTION_IS_CLOSED, null);
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException(CONNECTION_IS_CLOSED, null);
        }
    }

    @Override
    @Nullable
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SQL_SPECIFIC_TYPES_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureNotClosed();
        this.schemaName = JdbcConnection.readSchemaName(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureNotClosed();
        return this.schemaName;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        this.close();
    }

    @Override
    public final void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        this.ensureNotClosed();
        if (ms < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        this.networkTimeoutMillis = ms;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.networkTimeoutMillis;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void endRequest() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SHARDING_KEYS_ARE_NOT_SUPPORTED);
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SHARDING_KEYS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SHARDING_KEYS_ARE_NOT_SUPPORTED);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException(SHARDING_KEYS_ARE_NOT_SUPPORTED);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcConnection.class);
    }

    public ConnectionProperties properties() {
        return this.properties;
    }

    @TestOnly
    void closeClient() {
        this.igniteClient.close();
    }

    @TestOnly
    public int channelsCount() {
        return this.igniteClient.connections().size();
    }

    private static void checkCursorOptions(int resSetType, int resSetConcurrency, int resHoldability) throws SQLFeatureNotSupportedException {
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException(INVALID_RESULT_SET_TYPE);
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException(INVALID_RESULT_SET_CONCURRENCY);
        }
        if (resHoldability != 2) {
            throw new SQLFeatureNotSupportedException(INVALID_RESULT_SET_HOLDABILITY);
        }
    }

    private static String readSchemaName(String schemaName) {
        if (schemaName == null || schemaName.isEmpty()) {
            return SqlCommon.DEFAULT_SCHEMA_NAME;
        }
        return schemaName;
    }
}

