/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.table;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public final class QualifiedName
implements Serializable {
    private static final long serialVersionUID = -7016402388810709149L;
    public static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private final String schemaIdentifier;
    private final String objectIdentifier;

    public static QualifiedName parse(String simpleOrCanonicalName) {
        String objectName;
        String schemaName;
        QualifiedName.verifyObjectIdentifier(simpleOrCanonicalName);
        List<String> names = IgniteNameUtils.parseName(simpleOrCanonicalName);
        if (names.size() > 2) {
            throw new IllegalArgumentException("Canonical name format mismatch: " + simpleOrCanonicalName);
        }
        if (names.size() == 1) {
            schemaName = DEFAULT_SCHEMA_NAME;
            objectName = names.get(0);
        } else {
            schemaName = names.get(0);
            objectName = names.get(1);
        }
        QualifiedName.verifySchemaIdentifier(schemaName);
        QualifiedName.verifyObjectIdentifier(objectName);
        return new QualifiedName(schemaName, objectName);
    }

    public static QualifiedName fromSimple(String simpleName) {
        return QualifiedName.of(null, simpleName);
    }

    public static QualifiedName of(@Nullable String schemaName, String objectName) {
        if (schemaName == null) {
            schemaName = DEFAULT_SCHEMA_NAME;
        }
        QualifiedName.verifyObjectIdentifier(objectName);
        QualifiedName.verifySchemaIdentifier(schemaName);
        String schemaIdentifier = IgniteNameUtils.parseIdentifier(schemaName);
        String objectIdentifier = IgniteNameUtils.parseIdentifier(objectName);
        return new QualifiedName(schemaIdentifier, objectIdentifier);
    }

    QualifiedName(String schemaName, String objectName) {
        this.schemaIdentifier = schemaName;
        this.objectIdentifier = objectName;
    }

    public String schemaName() {
        return this.schemaIdentifier;
    }

    public String objectName() {
        return this.objectIdentifier;
    }

    public String toCanonicalForm() {
        return IgniteNameUtils.canonicalName(this.schemaIdentifier, this.objectIdentifier);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)object;
        return Objects.equals(this.schemaIdentifier, that.schemaIdentifier) && Objects.equals(this.objectIdentifier, that.objectIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.schemaIdentifier, this.objectIdentifier);
    }

    public String toString() {
        return "QualifiedName[schemaName='" + this.schemaIdentifier + "', objectName='" + this.objectIdentifier + "']";
    }

    private static void verifyObjectIdentifier(@Nullable String identifier) {
        Objects.requireNonNull(identifier);
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Object identifier can't be empty.");
        }
    }

    private static void verifySchemaIdentifier(@Nullable String identifier) {
        if (identifier != null && identifier.isEmpty()) {
            throw new IllegalArgumentException("Schema identifier can't be empty.");
        }
    }
}

