/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class RefCountedObjectPool<K, V> {
    private final Map<K, Integer> refCount = new HashMap<K, Integer>();
    private final Map<K, V> refCountedObjects = new HashMap();

    public synchronized V acquire(K key, Function<K, ? extends V> objectSupplier) {
        int currentRefCount = this.refCount.getOrDefault(key, 0);
        this.refCount.put(key, currentRefCount + 1);
        return this.refCountedObjects.computeIfAbsent(key, objectSupplier);
    }

    public synchronized boolean isAcquired(K key) {
        return this.refCount.containsKey(key);
    }

    public synchronized boolean release(K key) {
        int currentRefCount = this.refCount.getOrDefault(key, 0);
        int newRefCount = currentRefCount - 1;
        if (newRefCount < 0) {
            throw new IllegalStateException("Object " + key + " is not acquired");
        }
        if (newRefCount > 0) {
            this.refCount.put(key, newRefCount);
            return false;
        }
        this.refCount.remove(key);
        this.refCountedObjects.remove(key);
        return true;
    }
}

