/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.gridgain.shaded.org.apache.ignite.internal.util.FeatureChecker;
import org.gridgain.shaded.org.apache.ignite.internal.util.GridUnsafe;

abstract class PointerWrapping {
    private static final Object NULL_OBJ;
    private static final MethodHandle DIRECT_BUF_MTD;
    private static final MethodHandle DIRECT_BUF_CTOR_INT;
    private static final MethodHandle DIRECT_BUF_CTOR_LONG;
    private static final Object JAVA_NIO_ACCESS_OBJ;

    PointerWrapping() {
    }

    static ByteBuffer wrapPointer(long ptr, int len) {
        if (DIRECT_BUF_MTD != null && JAVA_NIO_ACCESS_OBJ != null) {
            return PointerWrapping.wrapPointerJavaNio(ptr, len);
        }
        if (DIRECT_BUF_CTOR_INT != null) {
            return PointerWrapping.wrapPointerDirectBufferConstructor(ptr, len);
        }
        if (DIRECT_BUF_CTOR_LONG != null) {
            return PointerWrapping.wrapPointerDirectBufferConstructor(ptr, (long)len);
        }
        throw new AssertionError((Object)("All alternatives for a new DirectByteBuffer() creation failed: " + FeatureChecker.JAVA_STARTUP_PARAMS_WARN));
    }

    private static Object javaNioAccessObject() {
        Class<?> cls;
        try {
            cls = Class.forName("jdk.internal.access.SharedSecrets");
        }
        catch (ClassNotFoundException e) {
            try {
                cls = Class.forName("jdk.internal.misc.SharedSecrets");
            }
            catch (ClassNotFoundException e1) {
                throw new AssertionError("Neither jdk.internal.access.SharedSecrets nor jdk.internal.misc.SharedSecrets are unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
            }
        }
        try {
            Method mth = cls.getMethod("getJavaNioAccess", new Class[0]);
            return mth.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError(cls.getName() + " class is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    private static MethodHandle newDirectBufferMethodHandle(Object nioAccessObj) {
        try {
            Class<?> cls = nioAccessObj.getClass();
            Method mtd = cls.getMethod("newDirectByteBuffer", Long.TYPE, Integer.TYPE, Object.class);
            AccessController.doPrivileged(() -> {
                mtd.setAccessible(true);
                return null;
            });
            MethodType mtdType = MethodType.methodType(ByteBuffer.class, Object.class, Long.TYPE, Integer.TYPE, Object.class);
            return MethodHandles.lookup().unreflect(mtd).asType(mtdType);
        }
        catch (ReflectiveOperationException | PrivilegedActionException e) {
            throw new AssertionError(nioAccessObj.getClass().getName() + "#newDirectByteBuffer() method is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    private static MethodHandle createAndTestNewDirectBufferCtor(Class<?> lengthType) {
        assert (lengthType == Integer.TYPE || lengthType == Long.TYPE) : "Unsupported type of length: " + lengthType;
        MethodHandle ctorCandidate = PointerWrapping.createNewDirectBufferCtor(lengthType);
        int l = 1;
        long ptr = GridUnsafe.UNSAFE.allocateMemory(l);
        try {
            ByteBuffer buf;
            ByteBuffer byteBuffer = buf = lengthType == Integer.TYPE ? ctorCandidate.invokeExact(ptr, l) : ctorCandidate.invokeExact(ptr, l);
            if (!buf.isDirect()) {
                throw new IllegalArgumentException("Buffer expected to be direct, internal error during #wrapPointerDirectBufCtor()");
            }
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        finally {
            GridUnsafe.UNSAFE.freeMemory(ptr);
        }
        return ctorCandidate;
    }

    private static MethodHandle createNewDirectBufferCtor(Class<?> lengthType) {
        try {
            ByteBuffer buf = ByteBuffer.allocateDirect(1).order(GridUnsafe.NATIVE_BYTE_ORDER);
            Constructor<?> ctor = buf.getClass().getDeclaredConstructor(Long.TYPE, lengthType);
            AccessController.doPrivileged(() -> {
                ctor.setAccessible(true);
                return null;
            });
            MethodType mtdType = MethodType.methodType(ByteBuffer.class, Long.TYPE, lengthType);
            return MethodHandles.lookup().unreflectConstructor(ctor).asType(mtdType);
        }
        catch (ReflectiveOperationException | PrivilegedActionException e) {
            throw new AssertionError("Unable to set up byte buffer creation using reflection :" + e.getMessage(), e);
        }
    }

    private static ByteBuffer wrapPointerJavaNio(long ptr, int len) {
        try {
            ByteBuffer buf = DIRECT_BUF_MTD.invokeExact(JAVA_NIO_ACCESS_OBJ, ptr, len, NULL_OBJ);
            assert (buf.isDirect()) : "ptr=" + ptr + ", len=" + len;
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
        catch (Throwable e) {
            throw new AssertionError("JavaNioAccess#newDirectByteBuffer() method is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    private static ByteBuffer wrapPointerDirectBufferConstructor(long ptr, int len) {
        try {
            ByteBuffer newDirectBuf = DIRECT_BUF_CTOR_INT.invokeExact(ptr, len);
            return newDirectBuf.order(GridUnsafe.NATIVE_BYTE_ORDER);
        }
        catch (Throwable e) {
            throw new AssertionError("DirectByteBuffer#constructor is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    private static ByteBuffer wrapPointerDirectBufferConstructor(long ptr, long len) {
        try {
            ByteBuffer newDirectBuf = DIRECT_BUF_CTOR_LONG.invokeExact(ptr, len);
            return newDirectBuf.order(GridUnsafe.NATIVE_BYTE_ORDER);
        }
        catch (Throwable e) {
            throw new AssertionError("DirectByteBuffer#constructor is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    static {
        MethodHandle directBufCtorWithLongLen;
        MethodHandle directBufCtorWithIntLen;
        MethodHandle directBufMtd;
        Object nioAccessObj;
        block6: {
            NULL_OBJ = null;
            nioAccessObj = null;
            directBufMtd = null;
            directBufCtorWithIntLen = null;
            directBufCtorWithLongLen = null;
            try {
                directBufCtorWithIntLen = PointerWrapping.createAndTestNewDirectBufferCtor(Integer.TYPE);
            }
            catch (Throwable e) {
                try {
                    directBufCtorWithLongLen = PointerWrapping.createAndTestNewDirectBufferCtor(Long.TYPE);
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                    try {
                        nioAccessObj = PointerWrapping.javaNioAccessObject();
                        directBufMtd = PointerWrapping.newDirectBufferMethodHandle(nioAccessObj);
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                    }
                    if (nioAccessObj != null && directBufMtd != null) break block6;
                    throw e;
                }
            }
        }
        DIRECT_BUF_MTD = directBufMtd;
        DIRECT_BUF_CTOR_INT = directBufCtorWithIntLen;
        DIRECT_BUF_CTOR_LONG = directBufCtorWithLongLen;
        JAVA_NIO_ACCESS_OBJ = nioAccessObj;
    }
}

