/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FastTimestamps {
    private static volatile long coarseCurrentTimeMillis = System.currentTimeMillis();
    private static final long UPDATE_INTERVAL_MS = 10L;

    private static void startUpdater() {
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "FastTimestamps updater");
            t.setDaemon(true);
            return t;
        });
        Runnable updaterTask = () -> {
            long now = System.currentTimeMillis();
            if (now > coarseCurrentTimeMillis) {
                coarseCurrentTimeMillis = now;
            }
            Thread.onSpinWait();
        };
        scheduledExecutor.scheduleAtFixedRate(updaterTask, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public static long coarseCurrentTimeMillis() {
        return coarseCurrentTimeMillis;
    }

    private FastTimestamps() {
    }

    static {
        FastTimestamps.startUpdater();
    }
}

