/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.thread;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class PublicApiThreading {
    private static final ThreadLocal<ApiEntryRole> THREAD_ROLE = new ThreadLocal();

    public static <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture, Executor asyncContinuationExecutor) {
        if (originalFuture.isDone()) {
            return originalFuture;
        }
        return originalFuture.whenCompleteAsync((res, ex) -> {}, asyncContinuationExecutor);
    }

    @Nullable
    private static ApiEntryRole getThreadRole() {
        return THREAD_ROLE.get();
    }

    public static void setThreadRole(@Nullable ApiEntryRole role) {
        THREAD_ROLE.set(role);
    }

    public static boolean executingSyncPublicApi() {
        return PublicApiThreading.getThreadRole() == ApiEntryRole.SYNC_PUBLIC_API;
    }

    public static boolean executingAsyncPublicApi() {
        return PublicApiThreading.getThreadRole() == ApiEntryRole.ASYNC_PUBLIC_API;
    }

    public static <T> T execUserSyncOperation(Supplier<T> operation) {
        return PublicApiThreading.executeWithRole(ApiEntryRole.SYNC_PUBLIC_API, operation);
    }

    public static void execUserSyncOperation(Runnable operation) {
        PublicApiThreading.execUserSyncOperation(() -> {
            operation.run();
            return null;
        });
    }

    public static <T> CompletableFuture<T> execUserAsyncOperation(Supplier<CompletableFuture<T>> operation) {
        return PublicApiThreading.executeWithRole(ApiEntryRole.ASYNC_PUBLIC_API, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeWithRole(ApiEntryRole newRole, Supplier<T> operation) {
        ApiEntryRole oldRole = PublicApiThreading.getThreadRole();
        if (oldRole != null) {
            return operation.get();
        }
        PublicApiThreading.setThreadRole(newRole);
        try {
            T t = operation.get();
            return t;
        }
        finally {
            PublicApiThreading.setThreadRole(oldRole);
        }
    }

    public static enum ApiEntryRole {
        SYNC_PUBLIC_API,
        ASYNC_PUBLIC_API;

    }
}

