/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.sql;

import java.util.Collections;
import java.util.List;
import org.gridgain.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.gridgain.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnMetadata;
import org.gridgain.shaded.org.apache.ignite.sql.ResultSetMetadata;

public class ResultSetMetadataImpl
implements ResultSetMetadata {
    private final List<ColumnMetadata> columns;
    @IgniteToStringExclude
    private final Object2IntMap<String> columnsIndices;

    public ResultSetMetadataImpl(List<ColumnMetadata> columns) {
        this.columns = Collections.unmodifiableList(columns);
        this.columnsIndices = new Object2IntOpenHashMap<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            ColumnMetadata column = columns.get(i);
            this.columnsIndices.put(column.name(), i);
        }
    }

    @Override
    public List<ColumnMetadata> columns() {
        return this.columns;
    }

    @Override
    public int indexOf(String columnName) {
        return this.columnsIndices.getOrDefault((Object)IgniteNameUtils.parseIdentifier(columnName), -1);
    }

    public String toString() {
        return S.toString(ResultSetMetadataImpl.class, this);
    }
}

