/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.properties;

import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridgain.shaded.org.apache.ignite.internal.properties.IgniteProperties;
import org.gridgain.shaded.org.apache.ignite.internal.util.StringUtils;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class IgniteProductVersion
implements Serializable,
Comparable<IgniteProductVersion> {
    public static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<maintenance>\\d+)(?:\\.(?<patch>\\d+))?(?:-(?<preRelease>[0-9A-Za-z]+))?");
    public static final IgniteProductVersion CURRENT_VERSION = IgniteProductVersion.fromString(IgniteProperties.get("ignite.version"));
    public static final String CURRENT_PRODUCT = IgniteProperties.get("ignite.product");
    public static final String VERSION_ATTR_NAME = "ignite.version";
    private final byte major;
    private final byte minor;
    private final byte maintenance;
    @Nullable
    private final Byte patch;
    @Nullable
    private final String preRelease;

    public IgniteProductVersion(byte major, byte minor, byte maintenance, @Nullable Byte patch, @Nullable String preRelease) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.patch = patch;
        this.preRelease = preRelease;
    }

    public static IgniteProductVersion fromString(String versionStr) {
        if (StringUtils.nullOrBlank(versionStr)) {
            throw new IllegalArgumentException("Ignite version is empty");
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected Ignite version format: " + versionStr);
        }
        String patch = matcher.group("patch");
        String preRelease = matcher.group("preRelease");
        return new IgniteProductVersion(Byte.parseByte(matcher.group("major")), Byte.parseByte(matcher.group("minor")), Byte.parseByte(matcher.group("maintenance")), StringUtils.nullOrBlank(patch) ? null : Byte.valueOf(Byte.parseByte(patch)), StringUtils.nullOrBlank(preRelease) ? null : preRelease);
    }

    public byte major() {
        return this.major;
    }

    public byte minor() {
        return this.minor;
    }

    public byte maintenance() {
        return this.maintenance;
    }

    @Nullable
    public Byte patch() {
        return this.patch;
    }

    @Nullable
    public String preRelease() {
        return this.preRelease;
    }

    @Override
    public int compareTo(IgniteProductVersion other) {
        int res = Byte.compare(this.major(), other.major());
        if (res != 0) {
            return res;
        }
        res = Byte.compare(this.minor(), other.minor());
        if (res != 0) {
            return res;
        }
        res = Byte.compare(this.maintenance(), other.maintenance());
        if (res != 0) {
            return res;
        }
        res = IgniteProductVersion.compareNullable(this.patch(), other.patch());
        if (res != 0) {
            return res;
        }
        res = IgniteProductVersion.compareNullable(IgniteProductVersion.preReleaseOrder(this.preRelease()), IgniteProductVersion.preReleaseOrder(other.preRelease()));
        return res;
    }

    private static int compareNullable(@Nullable Byte a, @Nullable Byte b) {
        if (a != null && b != null) {
            return Byte.compare(a, b);
        }
        if (a != null) {
            return 1;
        }
        if (b != null) {
            return -1;
        }
        return 0;
    }

    @Nullable
    private static Byte preReleaseOrder(@Nullable String preRelease) {
        if (preRelease == null) {
            return null;
        }
        switch (preRelease.toLowerCase()) {
            case "alpha": {
                return (byte)0;
            }
            case "beta": {
                return (byte)1;
            }
            case "rc": {
                return (byte)2;
            }
            case "final": 
            case "": {
                return (byte)3;
            }
        }
        return (byte)4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgniteProductVersion that = (IgniteProductVersion)o;
        return this.major == that.major && this.minor == that.minor && this.maintenance == that.maintenance && Objects.equals(this.patch, that.patch) && Objects.equals(this.preRelease, that.preRelease);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.maintenance, this.patch, this.preRelease);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(".").add(String.valueOf(this.major)).add(String.valueOf(this.minor)).add(String.valueOf(this.maintenance));
        if (this.patch != null) {
            joiner.add(this.patch.toString());
        }
        return joiner + (String)(this.preRelease == null ? "" : "-" + this.preRelease);
    }
}

