/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.continuousquery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.table.ContinuousQueryWatermark;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class ContinuousQueryEventWatermark
implements ContinuousQueryWatermark {
    private static final long serialVersionUID = -4277772354738071254L;
    private final UUID[] rowIds;
    private final long[] timestamps;

    ContinuousQueryEventWatermark(UUID[] rowIds, long[] timestamps) {
        assert (rowIds != null) : "rowIds == null";
        assert (timestamps != null) : "timestamps == null";
        assert (rowIds.length == timestamps.length) : "rowIds.length=" + rowIds.length + ", timestamps.length=" + timestamps.length;
        this.rowIds = rowIds;
        this.timestamps = timestamps;
    }

    public UUID[] rowIds() {
        return this.rowIds;
    }

    public long[] timestamps() {
        return this.timestamps;
    }

    public static ContinuousQueryEventWatermark cqEventWatermark(UUID[] rowIds, long[] timestamp) {
        return new ContinuousQueryEventWatermark(rowIds, timestamp);
    }

    @Nullable
    public static ContinuousQueryEventWatermark fromBytes(byte @Nullable [] watermarkBytes) {
        if (watermarkBytes == null) {
            return null;
        }
        assert (watermarkBytes.length % 24 == 0) : "Invalid watermark bytes length: " + watermarkBytes.length;
        int count = watermarkBytes.length / 24;
        UUID[] rowIds = new UUID[count];
        long[] timestamps = new long[count];
        ByteBuffer buf = ByteBuffer.wrap(watermarkBytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < count; ++i) {
            rowIds[i] = new UUID(buf.getLong(), buf.getLong());
            timestamps[i] = buf.getLong();
        }
        return new ContinuousQueryEventWatermark(rowIds, timestamps);
    }
}

