/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.gridgain.shaded.org.apache.ignite.client.IgniteClientConnectionException;
import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.gridgain.shaded.org.apache.ignite.internal.client.ClientChannel;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.TuplePart;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientPartitionAwarenessMetadata;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientResultSetMetadata;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientSqlRow;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientColumn;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientSchema;
import org.gridgain.shaded.org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.gridgain.shaded.org.apache.ignite.internal.marshaller.Marshaller;
import org.gridgain.shaded.org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.gridgain.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.shaded.org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.shaded.org.apache.ignite.lang.CursorClosedException;
import org.gridgain.shaded.org.apache.ignite.lang.ErrorGroups;
import org.gridgain.shaded.org.apache.ignite.lang.IgniteException;
import org.gridgain.shaded.org.apache.ignite.lang.MarshallerException;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnMetadata;
import org.gridgain.shaded.org.apache.ignite.sql.NoRowSetExpectedException;
import org.gridgain.shaded.org.apache.ignite.sql.ResultSetMetadata;
import org.gridgain.shaded.org.apache.ignite.sql.SqlRow;
import org.gridgain.shaded.org.apache.ignite.sql.async.AsyncResultSet;
import org.gridgain.shaded.org.apache.ignite.table.mapper.Mapper;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class ClientAsyncResultSet<T>
implements AsyncResultSet<T> {
    private final ClientChannel ch;
    private final Long resourceId;
    private final boolean hasRowSet;
    private final boolean wasApplied;
    private final long affectedRows;
    @Nullable
    private final ResultSetMetadata metadata;
    @Nullable
    private final ClientPartitionAwarenessMetadata partitionAwarenessMetadata;
    @Nullable
    private final Marshaller marshaller;
    @Nullable
    private final Mapper<T> mapper;
    @Nullable
    private volatile Page<T> page;
    private volatile boolean closed;
    private volatile CompletableFuture<Page<T>> nextPageFut;

    ClientAsyncResultSet(ClientChannel ch, MarshallersProvider marshallers, ClientMessageUnpacker in, @Nullable Mapper<T> mapper, boolean partitionAwarenessEnabled, boolean sqlDirectMappingSupported) {
        this.ch = ch;
        this.resourceId = in.tryUnpackNil() ? null : Long.valueOf(in.unpackLong());
        this.hasRowSet = in.unpackBoolean();
        boolean hasMorePages = in.unpackBoolean();
        this.wasApplied = in.unpackBoolean();
        this.affectedRows = in.unpackLong();
        this.metadata = ClientResultSetMetadata.read(in);
        this.partitionAwarenessMetadata = partitionAwarenessEnabled && !in.tryUnpackNil() ? ClientPartitionAwarenessMetadata.read(in, sqlDirectMappingSupported) : null;
        this.mapper = mapper;
        Marshaller marshaller = this.marshaller = this.metadata != null && mapper != null && mapper.targetType() != SqlRow.class ? ClientAsyncResultSet.marshaller(this.metadata, marshallers, mapper) : null;
        if (this.hasRowSet) {
            assert (this.metadata != null) : "Metadata must be present when row set is available";
            List<T> rows = ClientAsyncResultSet.readRows(in, this.metadata, this.marshaller, mapper);
            this.page = new Page<T>(rows, hasMorePages);
            if (hasMorePages) {
                assert (this.resourceId != null) : "Resource id must be present when more pages are available";
                this.nextPageFut = ClientAsyncResultSet.fetchNextPageInternal(ch, this.resourceId, this.marshaller, mapper, this.metadata);
            } else {
                this.closed = true;
            }
        }
    }

    @Override
    @Nullable
    public ResultSetMetadata metadata() {
        return this.metadata;
    }

    @Override
    public boolean hasRowSet() {
        return this.hasRowSet;
    }

    @Override
    public long affectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    @Override
    public Iterable<T> currentPage() {
        this.requireResultSet();
        Page<T> p = this.page;
        assert (p != null) : "Page must be present when row set is available";
        return p.rows;
    }

    @Override
    public int currentPageSize() {
        this.requireResultSet();
        Page<T> p = this.page;
        assert (p != null) : "Page must be present when row set is available";
        return p.rows.size();
    }

    @Override
    public synchronized CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        this.requireResultSet();
        if (this.closed || !this.hasMorePages()) {
            return CompletableFuture.failedFuture(new CursorClosedException());
        }
        return this.nextPageFut.thenApply(p -> {
            ClientAsyncResultSet clientAsyncResultSet = this;
            synchronized (clientAsyncResultSet) {
                this.page = p;
                if (p.hasMorePages) {
                    assert (this.resourceId != null) : "Resource id must be present when more pages are available";
                    this.nextPageFut = ClientAsyncResultSet.fetchNextPageInternal(this.ch, this.resourceId, this.marshaller, this.mapper, this.metadata);
                } else {
                    this.closed = true;
                }
            }
            return this;
        });
    }

    private static <T> CompletableFuture<Page<T>> fetchNextPageInternal(ClientChannel ch, long resourceId, @Nullable Marshaller marshaller, @Nullable Mapper<T> mapper, @Nullable ResultSetMetadata metadata) {
        return ch.serviceAsync(51, w -> w.out().packLong(resourceId), r -> {
            assert (metadata != null) : "Metadata must be present when row set is available";
            List rows = ClientAsyncResultSet.readRows(r.in(), metadata, marshaller, mapper);
            boolean hasMorePages = r.in().unpackBoolean();
            return new Page(rows, hasMorePages);
        });
    }

    @Override
    public boolean hasMorePages() {
        Page<T> p = this.page;
        return p != null && p.hasMorePages;
    }

    @Override
    public synchronized CompletableFuture<Void> closeAsync() {
        if (this.resourceId == null || this.closed) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.closed = true;
        CompletableFuture<Page<T>> nextPageFut0 = this.nextPageFut;
        if (nextPageFut0 != null) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)nextPageFut0.thenApply(p -> p.hasMorePages)).exceptionally(t -> true)).thenCompose(needsClose -> needsClose != false ? ClientAsyncResultSet.closeAsyncInternal(this.ch, this.resourceId) : CompletableFutures.nullCompletedFuture())).thenApply(ignore -> null);
        }
        return ClientAsyncResultSet.closeAsyncInternal(this.ch, this.resourceId).thenApply(ignore -> null);
    }

    @Nullable
    ClientPartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private static <T> List<T> readRows(ClientMessageUnpacker in, ResultSetMetadata metadata, @Nullable Marshaller marshaller, @Nullable Mapper<?> mapper) {
        int size = in.unpackInt();
        int rowSize = metadata.columns().size();
        ArrayList<Object> res = new ArrayList<Object>(size);
        if (marshaller == null) {
            for (int i = 0; i < size; ++i) {
                BinaryTupleReader tupleReader = new BinaryTupleReader(rowSize, in.readBinary());
                res.add(new ClientSqlRow(tupleReader, metadata));
            }
        } else {
            try {
                for (int i = 0; i < size; ++i) {
                    BinaryTupleReader tupleReader = new BinaryTupleReader(rowSize, in.readBinaryUnsafe());
                    ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader, null, TuplePart.KEY_AND_VAL);
                    res.add(marshaller.readObject(reader, null));
                }
            }
            catch (MarshallerException e) {
                assert (mapper != null);
                throw new MarshallerException("Failed to map SQL result set to type '" + mapper.targetType() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return Collections.unmodifiableList(res);
    }

    private static <T> Marshaller marshaller(ResultSetMetadata metadata, MarshallersProvider marshallers, Mapper<T> mapper) {
        ClientColumn[] schemaColumns = new ClientColumn[metadata.columns().size()];
        List<ColumnMetadata> columns = metadata.columns();
        for (int i = 0; i < columns.size(); ++i) {
            ClientColumn schemaColumn;
            ColumnMetadata metaColumn = columns.get(i);
            schemaColumns[i] = schemaColumn = new ClientColumn(metaColumn.name(), metaColumn.type(), metaColumn.nullable(), i, -1, -1, i, metaColumn.scale(), metaColumn.precision());
        }
        ClientSchema schema = new ClientSchema(0, schemaColumns, marshallers);
        return schema.getMarshaller(mapper);
    }

    private static CompletableFuture<Object> closeAsyncInternal(ClientChannel ch, long resourceId) {
        return ch.serviceAsync(52, w -> w.out().packLong(resourceId), null).exceptionally(t -> {
            Throwable cause = ExceptionUtils.unwrapCause(t);
            if (cause instanceof IgniteException) {
                IgniteException igniteEx = (IgniteException)cause;
                if (igniteEx.code() == ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR) {
                    throw new IgniteException(ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR, "Failed to find cursor with id: " + resourceId + ". Cursor might have been closed concurrently.", cause);
                }
                if (cause instanceof IgniteClientConnectionException) {
                    return null;
                }
            }
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to close SQL cursor: " + t.getMessage(), (Throwable)t);
        });
    }

    private static class Page<T> {
        private final List<T> rows;
        private final boolean hasMorePages;

        Page(List<T> rows, boolean hasMorePages) {
            this.rows = rows;
            this.hasMorePages = hasMorePages;
        }
    }
}

