/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class ClientFutureUtils {
    ClientFutureUtils() {
    }

    @Nullable
    static <T> T getNowSafe(CompletableFuture<T> fut) {
        try {
            return fut.getNow(null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static <T> CompletableFuture<T> doWithRetryAsync(Supplier<CompletableFuture<T>> func, Predicate<RetryContext> retryPredicate) {
        CompletableFuture resFut = new CompletableFuture();
        RetryContext ctx = new RetryContext();
        ClientFutureUtils.doWithRetryAsync(func, retryPredicate, resFut, ctx);
        return resFut;
    }

    private static <T> void doWithRetryAsync(Supplier<CompletableFuture<T>> func, Predicate<RetryContext> retryPredicate, CompletableFuture<T> resFut, RetryContext ctx) {
        func.get().whenComplete((res, err) -> {
            try {
                if (err == null) {
                    resFut.complete(res);
                    return;
                }
                Throwable resErr = null;
                RetryContext retryContext = ctx;
                synchronized (retryContext) {
                    if (ctx.errors == null) {
                        ctx.errors = new ArrayList();
                    }
                    ctx.errors.add((Throwable)err);
                    if (retryPredicate.test(ctx)) {
                        ++ctx.attempt;
                    } else {
                        resErr = ctx.errors.get(0);
                        for (int i = 1; i < ctx.errors.size(); ++i) {
                            resErr.addSuppressed(ctx.errors.get(i));
                        }
                    }
                }
                if (resErr != null) {
                    resFut.completeExceptionally(resErr);
                } else {
                    ClientFutureUtils.doWithRetryAsync(func, retryPredicate, resFut, ctx);
                }
            }
            catch (Throwable t) {
                resFut.completeExceptionally(t);
            }
        });
    }

    static class RetryContext {
        int attempt;
        @Nullable
        ArrayList<Throwable> errors;

        RetryContext() {
        }

        @Nullable
        Throwable lastError() {
            return this.errors == null || this.errors.isEmpty() ? null : this.errors.get(this.errors.size() - 1);
        }
    }
}

