/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.causality;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gridgain.shaded.org.apache.ignite.internal.causality.CompletionListener;
import org.gridgain.shaded.org.apache.ignite.internal.causality.DeletionListener;
import org.gridgain.shaded.org.apache.ignite.internal.causality.OutdatedTokenException;
import org.gridgain.shaded.org.apache.ignite.internal.causality.VersionedValue;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.gridgain.shaded.org.apache.ignite.internal.logger.Loggers;
import org.gridgain.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.shaded.org.apache.ignite.internal.util.Lazy;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class BaseVersionedValue<T>
implements VersionedValue<T> {
    private final IgniteLogger log = Loggers.forClass(BaseVersionedValue.class);
    private static final long NOT_INITIALIZED = -1L;
    static final int DEFAULT_MAX_HISTORY_SIZE = 10;
    private final String name;
    private final int maxHistorySize;
    private final List<CompletionListener<T>> completionListeners = new CopyOnWriteArrayList<CompletionListener<T>>();
    private final List<DeletionListener<T>> deletionListeners = new CopyOnWriteArrayList<DeletionListener<T>>();
    private final ConcurrentNavigableMap<Long, CompletableFuture<T>> history = new ConcurrentSkipListMap<Long, CompletableFuture<T>>();
    @Nullable
    private final Lazy<T> defaultValue;
    private long actualToken = -1L;
    private long deletedToken = -1L;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    BaseVersionedValue(String name, @Nullable Supplier<T> defaultValueSupplier) {
        this(name, 10, defaultValueSupplier);
    }

    BaseVersionedValue(String name, int maxHistorySize, @Nullable Supplier<T> defaultValueSupplier) {
        this.name = name;
        this.maxHistorySize = maxHistorySize;
        this.defaultValue = defaultValueSupplier == null ? null : new Lazy<T>(defaultValueSupplier);
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<T> get(long causalityToken) {
        assert (causalityToken > -1L) : IgniteStringFormatter.format("Reading with invalid causality token [name={}, token={}]", this.name, causalityToken);
        this.readWriteLock.readLock().lock();
        try {
            if (causalityToken > this.actualToken) {
                CompletableFuture completableFuture = this.history.computeIfAbsent(causalityToken, t -> new CompletableFuture());
                return completableFuture;
            }
            Map.Entry histEntry = this.history.floorEntry(causalityToken);
            if (histEntry == null) {
                throw new OutdatedTokenException(causalityToken, this.actualToken, this.maxHistorySize);
            }
            CompletableFuture completableFuture = (CompletableFuture)histEntry.getValue();
            return completableFuture;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public T latest() {
        for (CompletableFuture fut : this.history.descendingMap().values()) {
            if (!fut.isDone()) continue;
            return fut.join();
        }
        return this.getDefault();
    }

    @Override
    public long latestCausalityToken() {
        for (Map.Entry entry : this.history.descendingMap().entrySet()) {
            if (!((CompletableFuture)entry.getValue()).isDone()) continue;
            return (Long)entry.getKey();
        }
        return -1L;
    }

    @Nullable
    T getDefault() {
        return this.defaultValue == null ? null : (T)this.defaultValue.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> complete(long causalityToken) {
        CompletableFuture futureForToken;
        this.readWriteLock.writeLock().lock();
        try {
            this.setActualToken(causalityToken);
            CompletableFuture<T> previousCompleteFuture = this.completePreviousFutures();
            futureForToken = this.history.compute(causalityToken, (token, future) -> {
                if (future == null) {
                    return previousCompleteFuture == null ? CompletableFuture.completedFuture(this.getDefault()) : previousCompleteFuture;
                }
                if (previousCompleteFuture == null) {
                    future.complete(this.getDefault());
                } else {
                    this.copyState(previousCompleteFuture, (CompletableFuture<T>)future);
                }
                return future;
            });
            this.trimHistory();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return this.notifyCompletionListeners(causalityToken, futureForToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> complete(long causalityToken, CompletableFuture<T> future) {
        assert (future.isDone()) : IgniteStringFormatter.format("Future is not done during completion [name={}, future={}]", this.name, future);
        this.readWriteLock.writeLock().lock();
        try {
            this.setActualToken(causalityToken);
            this.completePreviousFutures();
            CompletableFuture<T> existingFuture = this.history.putIfAbsent(causalityToken, future);
            if (existingFuture != null) {
                this.copyState(future, existingFuture);
            }
            this.trimHistory();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return this.notifyCompletionListeners(causalityToken, future);
    }

    @Nullable
    private CompletableFuture<T> completePreviousFutures() {
        SortedMap headMap = this.history.headMap((Object)this.actualToken);
        if (headMap.isEmpty()) {
            return null;
        }
        List<CompletableFuture> futuresToComplete = List.of();
        CompletableFuture previousCompleteFuture = null;
        for (CompletableFuture future : headMap.descendingMap().values()) {
            if (future.isDone()) {
                previousCompleteFuture = future;
                break;
            }
            if (futuresToComplete.isEmpty()) {
                futuresToComplete = new ArrayList();
            }
            futuresToComplete.add(future);
        }
        if (futuresToComplete.isEmpty()) {
            return previousCompleteFuture;
        }
        if (previousCompleteFuture == null) {
            Object defaultValue = this.getDefault();
            futuresToComplete.forEach(f -> f.complete(defaultValue));
        } else {
            assert (previousCompleteFuture.isDone()) : IgniteStringFormatter.format("Future is not done during 'completePreviousFutures' [name={}, previousCompleteFuture={}]", this.name, previousCompleteFuture);
            List<CompletableFuture> futuresToCompleteCopy = futuresToComplete;
            previousCompleteFuture.whenComplete((T v, U t) -> {
                if (t != null) {
                    futuresToCompleteCopy.forEach(f -> f.completeExceptionally((Throwable)t));
                } else {
                    futuresToCompleteCopy.forEach(f -> f.complete(v));
                }
            });
        }
        return previousCompleteFuture;
    }

    private void setActualToken(long causalityToken) {
        assert (causalityToken > this.actualToken) : IgniteStringFormatter.format("Token must be greater than last applied [name={}, token={}, lastApplied={}]", this.name, causalityToken, this.actualToken);
        assert (causalityToken > this.deletedToken) : IgniteStringFormatter.format("Token must be greater than last deleted [name{}, token={}, lastDeleted={}]", this.name, causalityToken, this.deletedToken);
        this.actualToken = causalityToken;
    }

    private void trimHistory() {
        NavigableMap oldTokensMap = this.history.headMap((Object)this.actualToken, true);
        if (oldTokensMap.size() <= this.maxHistorySize) {
            return;
        }
        Iterator it = oldTokensMap.entrySet().iterator();
        for (int i = oldTokensMap.size(); i > this.maxHistorySize; --i) {
            Map.Entry next = it.next();
            assert (((CompletableFuture)next.getValue()).isDone()) : IgniteStringFormatter.format("Future is not done during 'trimHistory' [name={}, token={}, oldRevision={}, oldFuture={}]", this.name, this.actualToken, next.getKey(), next.getValue());
            it.remove();
        }
    }

    private void copyState(CompletableFuture<T> from, CompletableFuture<T> to) {
        assert (from.isDone()) : IgniteStringFormatter.format("Future is not done during 'copyState' [name={}, from={}]", this.name, from);
        assert (!to.isDone()) : IgniteStringFormatter.format("Copying state into a completed future [name={}, to={}]", this.name, to);
        from.whenComplete((BiConsumer)CompletableFutures.copyStateTo(to));
    }

    @Override
    public void whenComplete(CompletionListener<T> action) {
        this.completionListeners.add(action);
    }

    @Override
    public void removeWhenComplete(CompletionListener<T> action) {
        this.completionListeners.remove(action);
    }

    @Override
    public void whenDelete(DeletionListener<T> action) {
        this.deletionListeners.add(action);
    }

    @Override
    public void removeWhenDelete(DeletionListener<T> action) {
        this.deletionListeners.remove(action);
    }

    private CompletableFuture<Void> notifyCompletionListeners(long causalityToken, CompletableFuture<T> future) {
        return ((CompletableFuture)future.handle((v, t) -> {
            Throwable unpackedThrowable = t instanceof CompletionException ? t.getCause() : t;
            ArrayList futs = new ArrayList();
            for (CompletionListener<Object> completionListener : this.completionListeners) {
                try {
                    futs.add(completionListener.whenComplete(causalityToken, v, unpackedThrowable));
                }
                catch (Exception e) {
                    this.log.error("Exception when notifying a completion listener", (Throwable)e);
                }
            }
            return CompletableFutures.allOf(futs);
        })).thenCompose(Function.identity());
    }

    void deleteUpTo(long causalityToken) {
        this.readWriteLock.writeLock().lock();
        try {
            assert (causalityToken < this.actualToken) : IgniteStringFormatter.format("Token must be less than last applied [name={}, token={}, lastApplied={}]", this.name, causalityToken, this.actualToken);
            assert (causalityToken > this.deletedToken) : IgniteStringFormatter.format("Token must be greater than last deleted [name={}, token={}, lastDeleted={}]", this.name, causalityToken, this.deletedToken);
            this.deletedToken = causalityToken;
            this.history.headMap((Object)causalityToken, true).clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        for (DeletionListener<T> listener : this.deletionListeners) {
            try {
                listener.whenDelete(causalityToken);
            }
            catch (Exception e) {
                this.log.error("Exception when notifying a deletion listener", (Throwable)e);
            }
        }
    }
}

