/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.password;

import java.util.Set;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class BlowfishPasswordFormatValidator {
    private static final Set<String> KNOWN_VERSIONS = Set.of("2", "2x", "2a", "2y", "2b");
    private static final int BASE_HASH_LENGTH = 58;
    private static final int MIN_COST = 4;
    private static final int MAX_COST = 31;

    BlowfishPasswordFormatValidator() {
    }

    public static boolean isValidFormat(String bcryptPassword) {
        if (bcryptPassword == null) {
            return false;
        }
        String version = BlowfishPasswordFormatValidator.getVersion(bcryptPassword);
        if (version == null) {
            return false;
        }
        if (!KNOWN_VERSIONS.contains(version)) {
            return false;
        }
        int hashLength = bcryptPassword.length();
        if (hashLength - version.length() != 58) {
            return false;
        }
        int hashCost = BlowfishPasswordFormatValidator.getCost(bcryptPassword, version.length() + 2);
        return hashCost >= 4 && hashCost <= 31;
    }

    @Nullable
    private static String getVersion(String bcryptPassword) {
        if (bcryptPassword.length() < 58) {
            return null;
        }
        if (bcryptPassword.charAt(0) != '$') {
            return null;
        }
        if (bcryptPassword.charAt(2) == '$') {
            return bcryptPassword.substring(1, 2);
        }
        if (bcryptPassword.charAt(3) == '$') {
            return bcryptPassword.substring(1, 3);
        }
        return null;
    }

    private static int getCost(String bcryptPassword, int base) {
        String costStr = bcryptPassword.substring(base, base + 2);
        try {
            return Integer.parseInt(costStr);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

