/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;

public class JdbcResultSetMetadata
implements ResultSetMetaData {
    private static final int COL_WIDTH = 30;
    private final List<JdbcColumnMeta> meta;

    JdbcResultSetMetadata(List<JdbcColumnMeta> meta) {
        assert (meta != null);
        this.meta = meta;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.meta.size();
    }

    @Override
    public boolean isAutoIncrement(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int col) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int col) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int col) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int col) throws SQLException {
        return 30;
    }

    @Override
    public String getColumnLabel(int col) throws SQLException {
        return this.meta.get(col - 1).columnLabel();
    }

    @Override
    public String getColumnName(int col) throws SQLException {
        return this.meta.get(col - 1).columnName();
    }

    @Override
    public String getSchemaName(int col) throws SQLException {
        return this.meta.get(col - 1).schemaName();
    }

    @Override
    public int getPrecision(int col) throws SQLException {
        return this.meta.get(col - 1).precision();
    }

    @Override
    public int getScale(int col) throws SQLException {
        return this.meta.get(col - 1).scale();
    }

    @Override
    public String getTableName(int col) throws SQLException {
        return this.meta.get(col - 1).tableName();
    }

    @Override
    public String getCatalogName(int col) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int col) throws SQLException {
        return this.meta.get(col - 1).dataType();
    }

    @Override
    public String getColumnTypeName(int col) throws SQLException {
        return this.meta.get(col - 1).dataTypeName();
    }

    @Override
    public boolean isReadOnly(int col) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int col) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int col) throws SQLException {
        return this.meta.get(col - 1).dataTypeClass();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Result set meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcResultSetMetadata.class);
    }
}

